package com.xforceplus.ultraman.app.jcyangolocal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyangolocal.entity.BuyerInvoiceDetails;
import com.xforceplus.ultraman.app.jcyangolocal.service.IBuyerInvoiceDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-29
 */
@RestController
public class BuyerInvoiceDetailsController {

  @Autowired
  private IBuyerInvoiceDetailsService buyerInvoiceDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param buyerInvoiceDetails ${table.comment}
   * @return
   */
  @GetMapping("/buyerinvoicedetailss" )
  public XfR getBuyerInvoiceDetailss(XfPage page, BuyerInvoiceDetails buyerInvoiceDetails) {
    return XfR.ok(buyerInvoiceDetailsServiceImpl.page(page, Wrappers.query(buyerInvoiceDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/buyerinvoicedetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(buyerInvoiceDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param buyerInvoiceDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/buyerinvoicedetailss")
  public XfR save(@RequestBody BuyerInvoiceDetails buyerInvoiceDetails) {
     return XfR.ok(buyerInvoiceDetailsServiceImpl.save(buyerInvoiceDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param buyerInvoiceDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/buyerinvoicedetailss/{id}")
  public XfR putUpdate(@RequestBody BuyerInvoiceDetails buyerInvoiceDetails,@PathVariable Long id) {
      buyerInvoiceDetails.setId(id);
      return XfR.ok(buyerInvoiceDetailsServiceImpl.updateById(buyerInvoiceDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param buyerInvoiceDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/buyerinvoicedetailss/{id}")
  public XfR patchUpdate(@RequestBody BuyerInvoiceDetails buyerInvoiceDetails,@PathVariable Long id) {
      BuyerInvoiceDetails upbuyerInvoiceDetails = buyerInvoiceDetailsServiceImpl.getById(id);
      if(upbuyerInvoiceDetails != null){
        upbuyerInvoiceDetails = ObjectCopyUtils.copyProperties(buyerInvoiceDetails,upbuyerInvoiceDetails,true);
      }
      return XfR.ok(buyerInvoiceDetailsServiceImpl.updateById(upbuyerInvoiceDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/buyerinvoicedetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(buyerInvoiceDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/buyerinvoicedetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "buyer_invoice_details");
     params.put("request", condition);

     return XfR.ok(buyerInvoiceDetailsServiceImpl.querys(params));
  }

}
