package com.xforceplus.ultraman.app.jcyangolocal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyangolocal.entity.BuyerInvoiceMain;
import com.xforceplus.ultraman.app.jcyangolocal.service.IBuyerInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-29
 */
@RestController
public class BuyerInvoiceMainController {

  @Autowired
  private IBuyerInvoiceMainService buyerInvoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param buyerInvoiceMain ${table.comment}
   * @return
   */
  @GetMapping("/buyerinvoicemains" )
  public XfR getBuyerInvoiceMains(XfPage page, BuyerInvoiceMain buyerInvoiceMain) {
    return XfR.ok(buyerInvoiceMainServiceImpl.page(page, Wrappers.query(buyerInvoiceMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/buyerinvoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(buyerInvoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param buyerInvoiceMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/buyerinvoicemains")
  public XfR save(@RequestBody BuyerInvoiceMain buyerInvoiceMain) {
     return XfR.ok(buyerInvoiceMainServiceImpl.save(buyerInvoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param buyerInvoiceMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/buyerinvoicemains/{id}")
  public XfR putUpdate(@RequestBody BuyerInvoiceMain buyerInvoiceMain,@PathVariable Long id) {
      buyerInvoiceMain.setId(id);
      return XfR.ok(buyerInvoiceMainServiceImpl.updateById(buyerInvoiceMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param buyerInvoiceMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/buyerinvoicemains/{id}")
  public XfR patchUpdate(@RequestBody BuyerInvoiceMain buyerInvoiceMain,@PathVariable Long id) {
      BuyerInvoiceMain upbuyerInvoiceMain = buyerInvoiceMainServiceImpl.getById(id);
      if(upbuyerInvoiceMain != null){
        upbuyerInvoiceMain = ObjectCopyUtils.copyProperties(buyerInvoiceMain,upbuyerInvoiceMain,true);
      }
      return XfR.ok(buyerInvoiceMainServiceImpl.updateById(upbuyerInvoiceMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/buyerinvoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(buyerInvoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/buyerinvoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "buyer_invoice_main");
     params.put("request", condition);

     return XfR.ok(buyerInvoiceMainServiceImpl.querys(params));
  }

}
