package com.xforceplus.ultraman.app.jcyangolocal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyangolocal.entity.OpCompanyBookRelation;
import com.xforceplus.ultraman.app.jcyangolocal.service.IOpCompanyBookRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-29
 */
@RestController
public class OpCompanyBookRelationController {

  @Autowired
  private IOpCompanyBookRelationService opCompanyBookRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param opCompanyBookRelation ${table.comment}
   * @return
   */
  @GetMapping("/opcompanybookrelations" )
  public XfR getOpCompanyBookRelations(XfPage page, OpCompanyBookRelation opCompanyBookRelation) {
    return XfR.ok(opCompanyBookRelationServiceImpl.page(page, Wrappers.query(opCompanyBookRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/opcompanybookrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(opCompanyBookRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param opCompanyBookRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/opcompanybookrelations")
  public XfR save(@RequestBody OpCompanyBookRelation opCompanyBookRelation) {
     return XfR.ok(opCompanyBookRelationServiceImpl.save(opCompanyBookRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param opCompanyBookRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/opcompanybookrelations/{id}")
  public XfR putUpdate(@RequestBody OpCompanyBookRelation opCompanyBookRelation,@PathVariable Long id) {
      opCompanyBookRelation.setId(id);
      return XfR.ok(opCompanyBookRelationServiceImpl.updateById(opCompanyBookRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param opCompanyBookRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/opcompanybookrelations/{id}")
  public XfR patchUpdate(@RequestBody OpCompanyBookRelation opCompanyBookRelation,@PathVariable Long id) {
      OpCompanyBookRelation upopCompanyBookRelation = opCompanyBookRelationServiceImpl.getById(id);
      if(upopCompanyBookRelation != null){
        upopCompanyBookRelation = ObjectCopyUtils.copyProperties(opCompanyBookRelation,upopCompanyBookRelation,true);
      }
      return XfR.ok(opCompanyBookRelationServiceImpl.updateById(upopCompanyBookRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/opcompanybookrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(opCompanyBookRelationServiceImpl.removeById(id));
  }

  @PostMapping("/opcompanybookrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "op_company_book_relation");
     params.put("request", condition);

     return XfR.ok(opCompanyBookRelationServiceImpl.querys(params));
  }

}
