package com.xforceplus.ultraman.app.jcyangolocal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyangolocal.entity.OrderAccount;
import com.xforceplus.ultraman.app.jcyangolocal.service.IOrderAccountService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-29
 */
@RestController
public class OrderAccountController {

  @Autowired
  private IOrderAccountService orderAccountServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderAccount ${table.comment}
   * @return
   */
  @GetMapping("/orderaccounts" )
  public XfR getOrderAccounts(XfPage page, OrderAccount orderAccount) {
    return XfR.ok(orderAccountServiceImpl.page(page, Wrappers.query(orderAccount)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderaccounts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderAccountServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderAccount ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderaccounts")
  public XfR save(@RequestBody OrderAccount orderAccount) {
     return XfR.ok(orderAccountServiceImpl.save(orderAccount));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderAccount ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderaccounts/{id}")
  public XfR putUpdate(@RequestBody OrderAccount orderAccount,@PathVariable Long id) {
      orderAccount.setId(id);
      return XfR.ok(orderAccountServiceImpl.updateById(orderAccount));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderAccount ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderaccounts/{id}")
  public XfR patchUpdate(@RequestBody OrderAccount orderAccount,@PathVariable Long id) {
      OrderAccount uporderAccount = orderAccountServiceImpl.getById(id);
      if(uporderAccount != null){
        uporderAccount = ObjectCopyUtils.copyProperties(orderAccount,uporderAccount,true);
      }
      return XfR.ok(orderAccountServiceImpl.updateById(uporderAccount));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderaccounts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderAccountServiceImpl.removeById(id));
  }

  @PostMapping("/orderaccounts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_account");
     params.put("request", condition);

     return XfR.ok(orderAccountServiceImpl.querys(params));
  }

}
