package com.xforceplus.ultraman.app.jcyhxx.controller;


/**
 * 系统枚举扩展明细feign客户端
 *
 * @author ultraman
 * @date 2025-10-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyhxx.entity.SystemExtendDictItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-yhxx")
public interface SystemExtendDictItemFeignApi {

  /**
   * 通过id查询系统枚举扩展明细
   * @param  id
   * @return R
   */
  @GetMapping("/systemExtendDictItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统枚举扩展明细
   * @param systemExtendDictItem 系统枚举扩展明细
   * @return R
   */
  @PostMapping("/systemExtendDictItem/add")
  public R save(@RequestBody SystemExtendDictItem systemExtendDictItem);

  /**
   * 修改系统枚举扩展明细
   * @param systemExtendDictItem 系统枚举扩展明细
   * @return R
   */
  @PostMapping("/systemExtendDictItem/update")
  public R updateById(@RequestBody SystemExtendDictItem systemExtendDictItem);

  /**
   * 通过id删除系统枚举扩展明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemExtendDictItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}