package com.xforceplus.ultraman.app.jcyhxx.controller;


/**
 * 系统工作流程实例变量历史对象feign客户端
 *
 * @author ultraman
 * @date 2025-11-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyhxx.entity.SysFlowInsVarHis;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-yhxx")
public interface SysFlowInsVarHisFeignApi {

  /**
   * 通过id查询系统工作流程实例变量历史对象
   * @param  id
   * @return R
   */
  @GetMapping("/sysFlowInsVarHis/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统工作流程实例变量历史对象
   * @param sysFlowInsVarHis 系统工作流程实例变量历史对象
   * @return R
   */
  @PostMapping("/sysFlowInsVarHis/add")
  public R save(@RequestBody SysFlowInsVarHis sysFlowInsVarHis);

  /**
   * 修改系统工作流程实例变量历史对象
   * @param sysFlowInsVarHis 系统工作流程实例变量历史对象
   * @return R
   */
  @PostMapping("/sysFlowInsVarHis/update")
  public R updateById(@RequestBody SysFlowInsVarHis sysFlowInsVarHis);

  /**
   * 通过id删除系统工作流程实例变量历史对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/sysFlowInsVarHis/del/{id}" )
  public R removeById(@PathVariable Long id);

}