package com.xforceplus.ultraman.app.jcyhxx.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 应用配置系统对象
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SystemConfig implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 系统域名
   */
  private String domain;

  /**
   * 系统主题
   */
  private String theme;

  /**
   * Logo图片地址
   */
  private String logoUrl;

  /**
   * favicon图标url
   */
  private String faviconUrl;

  /**
   * 模块掩码
   */
  private String modulesMask;

  /**
   * 系统名称
   */
  private String name;

  /**
   * 页面超时时间
   */
  private String timeout;

  /**
   * 微前端插件
   */
  private String thirdPartMicroApps;

  /**
   * 三方微前端插件props
   */
  private String thirdPartMicroAppsProps;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 静态资源加载前缀
   */
  private String assetsUrlPrefix;

  /**
   * 应用编码
   */
  private String appCode;

  /**
   * saml认证租户id
   */
  private Long samlTenantId;

  /**
   * saml认证项目id
   */
  private String samlAppId;

  /**
   * 元数据加载地址
   */
  private String metadataUrl;

  /**
   * saml公钥信息
   */
  private String samlPublicKey;

  /**
   * saml认证租户code
   */
  private String samlTenantCode;

  /**
   * saml认证地址
   */
  private String samlAuthUrl;

  /**
   * 登录页Logo
   */
  private String loginLogoUrl;

  /**
   * 运营平台域名
   */
  private String adminDomain;

  /**
   * 登录页背景图片
   */
  private String loginBackgroundImageUrl;

  /**
   * 登录页系统标题
   */
  private String loginTitleHtml;

  /**
   * 登录页版权信息
   */
  private String loginCopyrightHtml;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("domain", domain);
      map.put("theme", theme);
      map.put("logo_url", logoUrl);
      map.put("favicon_url", faviconUrl);
      map.put("modules_mask", modulesMask);
      map.put("name", name);
      map.put("timeout", timeout);
      map.put("third_part_micro_apps", thirdPartMicroApps);
      map.put("third_part_micro_apps_props", thirdPartMicroAppsProps);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("assets_url_prefix", assetsUrlPrefix);
      map.put("app_code", appCode);
      map.put("saml_tenant_id", samlTenantId);
      map.put("saml_app_id", samlAppId);
      map.put("metadata_url", metadataUrl);
      map.put("saml_public_key", samlPublicKey);
      map.put("saml_tenant_code", samlTenantCode);
      map.put("saml_auth_url", samlAuthUrl);
      map.put("login_logo_url", loginLogoUrl);
      map.put("admin_domain", adminDomain);
      map.put("login_background_image_url", loginBackgroundImageUrl);
      map.put("login_title_html", loginTitleHtml);
      map.put("login_copyright_html", loginCopyrightHtml);
      map.put("org_tree", orgTree);

      return map;
  }

  public static SystemConfig fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SystemConfig entity = new SystemConfig();
    if(map.containsKey("domain")) {
      Object obj = map.get("domain");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomain((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("theme")) {
      Object obj = map.get("theme");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTheme((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logo_url")) {
      Object obj = map.get("logo_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogoUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("favicon_url")) {
      Object obj = map.get("favicon_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFaviconUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("modules_mask")) {
      Object obj = map.get("modules_mask");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setModulesMask((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("timeout")) {
      Object obj = map.get("timeout");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTimeout((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_part_micro_apps")) {
      Object obj = map.get("third_part_micro_apps");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartMicroApps((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_part_micro_apps_props")) {
      Object obj = map.get("third_part_micro_apps_props");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartMicroAppsProps((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assets_url_prefix")) {
      Object obj = map.get("assets_url_prefix");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssetsUrlPrefix((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("app_code")) {
      Object obj = map.get("app_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saml_tenant_id")) {
      Object obj = map.get("saml_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSamlTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSamlTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSamlTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saml_app_id")) {
      Object obj = map.get("saml_app_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSamlAppId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("metadata_url")) {
      Object obj = map.get("metadata_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMetadataUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saml_public_key")) {
      Object obj = map.get("saml_public_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSamlPublicKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saml_tenant_code")) {
      Object obj = map.get("saml_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSamlTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saml_auth_url")) {
      Object obj = map.get("saml_auth_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSamlAuthUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("login_logo_url")) {
      Object obj = map.get("login_logo_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLoginLogoUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("admin_domain")) {
      Object obj = map.get("admin_domain");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAdminDomain((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("login_background_image_url")) {
      Object obj = map.get("login_background_image_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLoginBackgroundImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("login_title_html")) {
      Object obj = map.get("login_title_html");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLoginTitleHtml((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("login_copyright_html")) {
      Object obj = map.get("login_copyright_html");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLoginCopyrightHtml((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("domain")) {
      Object obj = map.get("domain");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomain((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("theme")) {
      Object obj = map.get("theme");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTheme((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logo_url")) {
      Object obj = map.get("logo_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogoUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("favicon_url")) {
      Object obj = map.get("favicon_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFaviconUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("modules_mask")) {
      Object obj = map.get("modules_mask");
      if(obj != null) {
        if(obj instanceof String) {
          this.setModulesMask((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("timeout")) {
      Object obj = map.get("timeout");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTimeout((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_part_micro_apps")) {
      Object obj = map.get("third_part_micro_apps");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartMicroApps((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_part_micro_apps_props")) {
      Object obj = map.get("third_part_micro_apps_props");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartMicroAppsProps((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assets_url_prefix")) {
      Object obj = map.get("assets_url_prefix");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssetsUrlPrefix((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("app_code")) {
      Object obj = map.get("app_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saml_tenant_id")) {
      Object obj = map.get("saml_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSamlTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSamlTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSamlTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("saml_app_id")) {
      Object obj = map.get("saml_app_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSamlAppId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("metadata_url")) {
      Object obj = map.get("metadata_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMetadataUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saml_public_key")) {
      Object obj = map.get("saml_public_key");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSamlPublicKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saml_tenant_code")) {
      Object obj = map.get("saml_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSamlTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saml_auth_url")) {
      Object obj = map.get("saml_auth_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSamlAuthUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("login_logo_url")) {
      Object obj = map.get("login_logo_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLoginLogoUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("admin_domain")) {
      Object obj = map.get("admin_domain");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAdminDomain((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("login_background_image_url")) {
      Object obj = map.get("login_background_image_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLoginBackgroundImageUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("login_title_html")) {
      Object obj = map.get("login_title_html");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLoginTitleHtml((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("login_copyright_html")) {
      Object obj = map.get("login_copyright_html");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLoginCopyrightHtml((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
