package com.xforceplus.ultraman.app.jcyhxx.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyhxx.entity.SystemConfig;
import com.xforceplus.ultraman.app.jcyhxx.service.ISystemConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应用配置系统对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class SystemConfigController {

  @Autowired
  private ISystemConfigService systemConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemConfig 应用配置系统对象
   * @return
   */
  @GetMapping("/systemconfigs" )
  public XfR getSystemConfigs(XfPage page, SystemConfig systemConfig) {
    return XfR.ok(systemConfigServiceImpl.page(page, Wrappers.query(systemConfig)));
  }

  /**
   * 通过id查询应用配置系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemConfigServiceImpl.getById(id));
  }

  /**
   * 新增应用配置系统对象
   * @param systemConfig 应用配置系统对象
   * @return XfR
   */
  @PostMapping("/systemconfigs")
  public XfR save(@RequestBody SystemConfig systemConfig) {
     return XfR.ok(systemConfigServiceImpl.save(systemConfig));
  }

  /**
   * 修改-传入修改后的全部数据应用配置系统对象
   * @param systemConfig 应用配置系统对象
   * @return XfR
   */
  @PutMapping("/systemconfigs/{id}")
  public XfR putUpdate(@RequestBody SystemConfig systemConfig,@PathVariable Long id) {
      systemConfig.setId(id);
      return XfR.ok(systemConfigServiceImpl.updateById(systemConfig));
  }

  /**
   * 修改-传入修改的数据应用配置系统对象
   * @param systemConfig 应用配置系统对象
   * @return XfR
   */
  @PatchMapping("/systemconfigs/{id}")
  public XfR patchUpdate(@RequestBody SystemConfig systemConfig,@PathVariable Long id) {
      SystemConfig upsystemConfig = systemConfigServiceImpl.getById(id);
      if(upsystemConfig != null){
        upsystemConfig = ObjectCopyUtils.copyProperties(systemConfig,upsystemConfig,true);
      }
      return XfR.ok(systemConfigServiceImpl.updateById(upsystemConfig));
  }

  /**
   * 通过id删除应用配置系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemConfigServiceImpl.removeById(id));
  }

  @PostMapping("/systemconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_config");
     params.put("request", condition);

     return XfR.ok(systemConfigServiceImpl.querys(params));
  }

}
