package com.xforceplus.ultraman.app.jcyhxx.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyhxx.entity.InvoiceSerialNo;
import com.xforceplus.ultraman.app.jcyhxx.service.IInvoiceSerialNoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-11-05
 */
@RestController
public class InvoiceSerialNoController {

  @Autowired
  private IInvoiceSerialNoService invoiceSerialNoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceSerialNo ${table.comment}
   * @return
   */
  @GetMapping("/invoiceserialnos" )
  public XfR getInvoiceSerialNos(XfPage page, InvoiceSerialNo invoiceSerialNo) {
    return XfR.ok(invoiceSerialNoServiceImpl.page(page, Wrappers.query(invoiceSerialNo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceserialnos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceSerialNoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceSerialNo ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceserialnos")
  public XfR save(@RequestBody InvoiceSerialNo invoiceSerialNo) {
     return XfR.ok(invoiceSerialNoServiceImpl.save(invoiceSerialNo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceSerialNo ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceserialnos/{id}")
  public XfR putUpdate(@RequestBody InvoiceSerialNo invoiceSerialNo,@PathVariable Long id) {
      invoiceSerialNo.setId(id);
      return XfR.ok(invoiceSerialNoServiceImpl.updateById(invoiceSerialNo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceSerialNo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceserialnos/{id}")
  public XfR patchUpdate(@RequestBody InvoiceSerialNo invoiceSerialNo,@PathVariable Long id) {
      InvoiceSerialNo upinvoiceSerialNo = invoiceSerialNoServiceImpl.getById(id);
      if(upinvoiceSerialNo != null){
        upinvoiceSerialNo = ObjectCopyUtils.copyProperties(invoiceSerialNo,upinvoiceSerialNo,true);
      }
      return XfR.ok(invoiceSerialNoServiceImpl.updateById(upinvoiceSerialNo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceserialnos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceSerialNoServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceserialnos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_serial_no");
     params.put("request", condition);

     return XfR.ok(invoiceSerialNoServiceImpl.querys(params));
  }

}
