package com.xforceplus.ultraman.app.jcyhxx.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyhxx.entity.SysFlowActInsHis;
import com.xforceplus.ultraman.app.jcyhxx.service.ISysFlowActInsHisService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统流程节点实例历史对象前端控制器
 *
 * @author ultraman
 * @date 2025-11-05
 */
@RestController
public class SysFlowActInsHisController {

  @Autowired
  private ISysFlowActInsHisService sysFlowActInsHisServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysFlowActInsHis 系统流程节点实例历史对象
   * @return
   */
  @GetMapping("/sysflowactinshiss" )
  public XfR getSysFlowActInsHiss(XfPage page, SysFlowActInsHis sysFlowActInsHis) {
    return XfR.ok(sysFlowActInsHisServiceImpl.page(page, Wrappers.query(sysFlowActInsHis)));
  }

  /**
   * 通过id查询系统流程节点实例历史对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/sysflowactinshiss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysFlowActInsHisServiceImpl.getById(id));
  }

  /**
   * 新增系统流程节点实例历史对象
   * @param sysFlowActInsHis 系统流程节点实例历史对象
   * @return XfR
   */
  @PostMapping("/sysflowactinshiss")
  public XfR save(@RequestBody SysFlowActInsHis sysFlowActInsHis) {
     return XfR.ok(sysFlowActInsHisServiceImpl.save(sysFlowActInsHis));
  }

  /**
   * 修改-传入修改后的全部数据系统流程节点实例历史对象
   * @param sysFlowActInsHis 系统流程节点实例历史对象
   * @return XfR
   */
  @PutMapping("/sysflowactinshiss/{id}")
  public XfR putUpdate(@RequestBody SysFlowActInsHis sysFlowActInsHis,@PathVariable Long id) {
      sysFlowActInsHis.setId(id);
      return XfR.ok(sysFlowActInsHisServiceImpl.updateById(sysFlowActInsHis));
  }

  /**
   * 修改-传入修改的数据系统流程节点实例历史对象
   * @param sysFlowActInsHis 系统流程节点实例历史对象
   * @return XfR
   */
  @PatchMapping("/sysflowactinshiss/{id}")
  public XfR patchUpdate(@RequestBody SysFlowActInsHis sysFlowActInsHis,@PathVariable Long id) {
      SysFlowActInsHis upsysFlowActInsHis = sysFlowActInsHisServiceImpl.getById(id);
      if(upsysFlowActInsHis != null){
        upsysFlowActInsHis = ObjectCopyUtils.copyProperties(sysFlowActInsHis,upsysFlowActInsHis,true);
      }
      return XfR.ok(sysFlowActInsHisServiceImpl.updateById(upsysFlowActInsHis));
  }

  /**
   * 通过id删除系统流程节点实例历史对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sysflowactinshiss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysFlowActInsHisServiceImpl.removeById(id));
  }

  @PostMapping("/sysflowactinshiss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_flow_act_ins_his");
     params.put("request", condition);

     return XfR.ok(sysFlowActInsHisServiceImpl.querys(params));
  }

}
