package com.xforceplus.ultraman.app.jcyinyue.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-16
 */
public enum InvoiceKind {

    C("c", "增值税普通发票"),
    S("s", "增值税专用发票"),
    SE("se", "增值税电子专用发票"),
    CE("ce", "增值税电子普通发票"),
    CT("ct", "通行费发票"),
    JU("ju", "增值税普通发票（卷票）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceKind(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceKind fromCode(String code){
        switch(code) {
            case "c":
                return C;
            case "s":
                return S;
            case "se":
                return SE;
            case "ce":
                return CE;
            case "ct":
                return CT;
            case "ju":
                return JU;
            default:
                return null;
        }
    }
}
