package com.xforceplus.ultraman.app.jcyinyue.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 账户类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public enum AccountType {

    AR("AR", "销方"),
    AP("AP", "购方");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AccountType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountType fromCode(String code) {
        return Stream.of(AccountType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
