package com.xforceplus.ultraman.app.jcyinyue.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红字申请状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public enum ApplyingStatus {

    _1("1", "待申请"),
    _2("2", "申请中"),
    _3("3", "已申请");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyingStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyingStatus fromCode(String code) {
        return Stream.of(ApplyingStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
