package com.xforceplus.ultraman.app.jcyinyue.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public enum DataSource {

    SALES_V4("SALES_V4", "4.0 销项"),
    PURCHASE_V4("PURCHASE_V4", "4.0 进项"),
    SALES_V3("SALES_V3", "3.0 销项"),
    PURCHASE_V3("PURCHASE_V3", "3.0 进项"),
    TAXWARE_LF("TAXWARE_LF", "税件发票低频"),
    TAXWARE_CO("TAXWARE_CO", "税件发票归集"),
    IMAGE("IMAGE", "电子影像"),
    PURCHASE_V5("PURCHASE_V5", "4.0 进项（新）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataSource fromCode(String code) {
        return Stream.of(DataSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
