package com.xforceplus.ultraman.app.jcyinyue.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * generateModel
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public enum GenerateModel {

    _0("0", "全部合并"),
    _1("1", "按销方公司拆分"),
    _2("2", "按购方公司拆分");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    GenerateModel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GenerateModel fromCode(String code) {
        return Stream.of(GenerateModel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
