package com.xforceplus.ultraman.app.jcyinyue.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 覆盖规则
 * </p>
 *
 * @author ultraman
 * @since 2023-06-15
 */
public enum CoverRule {

    _1("1", "是"),
    _0("0", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CoverRule(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CoverRule fromCode(String code) {
        return Stream.of(CoverRule.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
