package com.xforceplus.ultraman.app.jcyinyue.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否享受税收优惠政策
 * </p>
 *
 * @author ultraman
 * @since 2023-06-15
 */
public enum TaxPre {

    _0("0", "不享受"),
    _1("1", "享受");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxPre(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxPre fromCode(String code) {
        return Stream.of(TaxPre.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
