package com.xforceplus.ultraman.app.jcyinyue.metadata.validator;

import com.xforceplus.ultraman.app.jcyinyue.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcyinyue.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-06-15
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = null != AccountType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = null != InvoiceKind.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = null != InvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = null != ReverseStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = null != InvoiceColor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStyleType.class)) {
            isValid = null != InvoiceStyleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStyleType.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialType.class)) {
            isValid = null != SpecialType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = null != TaxPre.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = null != DataSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind1683271977848.class)) {
            isValid = null != InvoiceKind1683271977848.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceKind1683271977848.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyingStatus.class)) {
            isValid = null != ApplyingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(GenerateModel.class)) {
            isValid = null != GenerateModel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GenerateModel.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsStatus.class)) {
            isValid = null != GoodsStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GoodsStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CoverRule.class)) {
            isValid = null != CoverRule.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CoverRule.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsSource.class)) {
            isValid = null != GoodsSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GoodsSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ImportInvoiceStatus.class)) {
            isValid = null != ImportInvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImportInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryServiceReason.class)) {
            isValid = null != InventoryServiceReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InventoryServiceReason.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryDetailDirection.class)) {
            isValid = null != InventoryDetailDirection.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InventoryDetailDirection.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryDetailType.class)) {
            isValid = null != InventoryDetailType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InventoryDetailType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
