package com.xforceplus.ultraman.app.jcyinyue.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyinyue.entity.BillRedNo;
import com.xforceplus.ultraman.app.jcyinyue.service.IBillRedNoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class BillRedNoController {

  @Autowired
  private IBillRedNoService billRedNoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billRedNo ${table.comment}
   * @return
   */
  @GetMapping("/billrednos" )
  public XfR getBillRedNos(XfPage page, BillRedNo billRedNo) {
    return XfR.ok(billRedNoServiceImpl.page(page, Wrappers.query(billRedNo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billrednos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billRedNoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billRedNo ${table.comment}
   * @return XfR
   */
  @PostMapping("/billrednos")
  public XfR save(@RequestBody BillRedNo billRedNo) {
     return XfR.ok(billRedNoServiceImpl.save(billRedNo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billRedNo ${table.comment}
   * @return XfR
   */
  @PutMapping("/billrednos/{id}")
  public XfR putUpdate(@RequestBody BillRedNo billRedNo,@PathVariable Long id) {
      billRedNo.setId(id);
      return XfR.ok(billRedNoServiceImpl.updateById(billRedNo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billRedNo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billrednos/{id}")
  public XfR patchUpdate(@RequestBody BillRedNo billRedNo,@PathVariable Long id) {
      BillRedNo upbillRedNo = billRedNoServiceImpl.getById(id);
      if(upbillRedNo != null){
        upbillRedNo = ObjectCopyUtils.copyProperties(billRedNo,upbillRedNo,true);
      }
      return XfR.ok(billRedNoServiceImpl.updateById(upbillRedNo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billrednos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billRedNoServiceImpl.removeById(id));
  }

  @PostMapping("/billrednos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_red_no");
     params.put("request", condition);

     return XfR.ok(billRedNoServiceImpl.querys(params));
  }

}
