package com.xforceplus.ultraman.app.jcyinyue.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyinyue.entity.Detail1;
import com.xforceplus.ultraman.app.jcyinyue.service.IDetail1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class Detail1Controller {

  @Autowired
  private IDetail1Service detail1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param detail1 ${table.comment}
   * @return
   */
  @GetMapping("/detail1s" )
  public XfR getDetail1s(XfPage page, Detail1 detail1) {
    return XfR.ok(detail1ServiceImpl.page(page, Wrappers.query(detail1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/detail1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(detail1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param detail1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/detail1s")
  public XfR save(@RequestBody Detail1 detail1) {
     return XfR.ok(detail1ServiceImpl.save(detail1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param detail1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/detail1s/{id}")
  public XfR putUpdate(@RequestBody Detail1 detail1,@PathVariable Long id) {
      detail1.setId(id);
      return XfR.ok(detail1ServiceImpl.updateById(detail1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param detail1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/detail1s/{id}")
  public XfR patchUpdate(@RequestBody Detail1 detail1,@PathVariable Long id) {
      Detail1 updetail1 = detail1ServiceImpl.getById(id);
      if(updetail1 != null){
        updetail1 = ObjectCopyUtils.copyProperties(detail1,updetail1,true);
      }
      return XfR.ok(detail1ServiceImpl.updateById(updetail1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/detail1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(detail1ServiceImpl.removeById(id));
  }

  @PostMapping("/detail1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "detail1");
     params.put("request", condition);

     return XfR.ok(detail1ServiceImpl.querys(params));
  }

}
