package com.xforceplus.ultraman.app.jcyinyue.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyinyue.entity.Detail2;
import com.xforceplus.ultraman.app.jcyinyue.service.IDetail2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class Detail2Controller {

  @Autowired
  private IDetail2Service detail2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param detail2 ${table.comment}
   * @return
   */
  @GetMapping("/detail2s" )
  public XfR getDetail2s(XfPage page, Detail2 detail2) {
    return XfR.ok(detail2ServiceImpl.page(page, Wrappers.query(detail2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/detail2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(detail2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param detail2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/detail2s")
  public XfR save(@RequestBody Detail2 detail2) {
     return XfR.ok(detail2ServiceImpl.save(detail2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param detail2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/detail2s/{id}")
  public XfR putUpdate(@RequestBody Detail2 detail2,@PathVariable Long id) {
      detail2.setId(id);
      return XfR.ok(detail2ServiceImpl.updateById(detail2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param detail2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/detail2s/{id}")
  public XfR patchUpdate(@RequestBody Detail2 detail2,@PathVariable Long id) {
      Detail2 updetail2 = detail2ServiceImpl.getById(id);
      if(updetail2 != null){
        updetail2 = ObjectCopyUtils.copyProperties(detail2,updetail2,true);
      }
      return XfR.ok(detail2ServiceImpl.updateById(updetail2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/detail2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(detail2ServiceImpl.removeById(id));
  }

  @PostMapping("/detail2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "detail2");
     params.put("request", condition);

     return XfR.ok(detail2ServiceImpl.querys(params));
  }

}
