package com.xforceplus.ultraman.app.jcyinyue.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyinyue.entity.DiJia;
import com.xforceplus.ultraman.app.jcyinyue.service.IDiJiaService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class DiJiaController {

  @Autowired
  private IDiJiaService diJiaServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param diJia ${table.comment}
   * @return
   */
  @GetMapping("/dijias" )
  public XfR getDiJias(XfPage page, DiJia diJia) {
    return XfR.ok(diJiaServiceImpl.page(page, Wrappers.query(diJia)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dijias/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(diJiaServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param diJia ${table.comment}
   * @return XfR
   */
  @PostMapping("/dijias")
  public XfR save(@RequestBody DiJia diJia) {
     return XfR.ok(diJiaServiceImpl.save(diJia));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param diJia ${table.comment}
   * @return XfR
   */
  @PutMapping("/dijias/{id}")
  public XfR putUpdate(@RequestBody DiJia diJia,@PathVariable Long id) {
      diJia.setId(id);
      return XfR.ok(diJiaServiceImpl.updateById(diJia));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param diJia ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dijias/{id}")
  public XfR patchUpdate(@RequestBody DiJia diJia,@PathVariable Long id) {
      DiJia updiJia = diJiaServiceImpl.getById(id);
      if(updiJia != null){
        updiJia = ObjectCopyUtils.copyProperties(diJia,updiJia,true);
      }
      return XfR.ok(diJiaServiceImpl.updateById(updiJia));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dijias/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(diJiaServiceImpl.removeById(id));
  }

  @PostMapping("/dijias/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "di_jia");
     params.put("request", condition);

     return XfR.ok(diJiaServiceImpl.querys(params));
  }

}
