package com.xforceplus.ultraman.app.jcyinyue.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyinyue.entity.Invoice1;
import com.xforceplus.ultraman.app.jcyinyue.service.IInvoice1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class Invoice1Controller {

  @Autowired
  private IInvoice1Service invoice1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoice1 ${table.comment}
   * @return
   */
  @GetMapping("/invoice1s" )
  public XfR getInvoice1s(XfPage page, Invoice1 invoice1) {
    return XfR.ok(invoice1ServiceImpl.page(page, Wrappers.query(invoice1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoice1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoice1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoice1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoice1s")
  public XfR save(@RequestBody Invoice1 invoice1) {
     return XfR.ok(invoice1ServiceImpl.save(invoice1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoice1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoice1s/{id}")
  public XfR putUpdate(@RequestBody Invoice1 invoice1,@PathVariable Long id) {
      invoice1.setId(id);
      return XfR.ok(invoice1ServiceImpl.updateById(invoice1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoice1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoice1s/{id}")
  public XfR patchUpdate(@RequestBody Invoice1 invoice1,@PathVariable Long id) {
      Invoice1 upinvoice1 = invoice1ServiceImpl.getById(id);
      if(upinvoice1 != null){
        upinvoice1 = ObjectCopyUtils.copyProperties(invoice1,upinvoice1,true);
      }
      return XfR.ok(invoice1ServiceImpl.updateById(upinvoice1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoice1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoice1ServiceImpl.removeById(id));
  }

  @PostMapping("/invoice1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice1");
     params.put("request", condition);

     return XfR.ok(invoice1ServiceImpl.querys(params));
  }

}
