package com.xforceplus.ultraman.app.jcyinyue.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyinyue.entity.Invoicetwo;
import com.xforceplus.ultraman.app.jcyinyue.service.IInvoicetwoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * invoicetwo前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class InvoicetwoController {

  @Autowired
  private IInvoicetwoService invoicetwoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoicetwo invoicetwo
   * @return
   */
  @GetMapping("/invoicetwos" )
  public XfR getInvoicetwos(XfPage page, Invoicetwo invoicetwo) {
    return XfR.ok(invoicetwoServiceImpl.page(page, Wrappers.query(invoicetwo)));
  }

  /**
   * 通过id查询invoicetwo
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicetwos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoicetwoServiceImpl.getById(id));
  }

  /**
   * 新增invoicetwo
   * @param invoicetwo invoicetwo
   * @return XfR
   */
  @PostMapping("/invoicetwos")
  public XfR save(@RequestBody Invoicetwo invoicetwo) {
     return XfR.ok(invoicetwoServiceImpl.save(invoicetwo));
  }

  /**
   * 修改-传入修改后的全部数据invoicetwo
   * @param invoicetwo invoicetwo
   * @return XfR
   */
  @PutMapping("/invoicetwos/{id}")
  public XfR putUpdate(@RequestBody Invoicetwo invoicetwo,@PathVariable Long id) {
      invoicetwo.setId(id);
      return XfR.ok(invoicetwoServiceImpl.updateById(invoicetwo));
  }

  /**
   * 修改-传入修改的数据invoicetwo
   * @param invoicetwo invoicetwo
   * @return XfR
   */
  @PatchMapping("/invoicetwos/{id}")
  public XfR patchUpdate(@RequestBody Invoicetwo invoicetwo,@PathVariable Long id) {
      Invoicetwo upinvoicetwo = invoicetwoServiceImpl.getById(id);
      if(upinvoicetwo != null){
        upinvoicetwo = ObjectCopyUtils.copyProperties(invoicetwo,upinvoicetwo,true);
      }
      return XfR.ok(invoicetwoServiceImpl.updateById(upinvoicetwo));
  }

  /**
   * 通过id删除invoicetwo
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicetwos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoicetwoServiceImpl.removeById(id));
  }

  @PostMapping("/invoicetwos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoicetwo");
     params.put("request", condition);

     return XfR.ok(invoicetwoServiceImpl.querys(params));
  }

}
