package com.xforceplus.ultraman.app.jcyinyue.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyinyue.entity.Main;
import com.xforceplus.ultraman.app.jcyinyue.service.IMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class MainController {

  @Autowired
  private IMainService mainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param main ${table.comment}
   * @return
   */
  @GetMapping("/mains" )
  public XfR getMains(XfPage page, Main main) {
    return XfR.ok(mainServiceImpl.page(page, Wrappers.query(main)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param main ${table.comment}
   * @return XfR
   */
  @PostMapping("/mains")
  public XfR save(@RequestBody Main main) {
     return XfR.ok(mainServiceImpl.save(main));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param main ${table.comment}
   * @return XfR
   */
  @PutMapping("/mains/{id}")
  public XfR putUpdate(@RequestBody Main main,@PathVariable Long id) {
      main.setId(id);
      return XfR.ok(mainServiceImpl.updateById(main));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param main ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mains/{id}")
  public XfR patchUpdate(@RequestBody Main main,@PathVariable Long id) {
      Main upmain = mainServiceImpl.getById(id);
      if(upmain != null){
        upmain = ObjectCopyUtils.copyProperties(main,upmain,true);
      }
      return XfR.ok(mainServiceImpl.updateById(upmain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mainServiceImpl.removeById(id));
  }

  @PostMapping("/mains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "main");
     params.put("request", condition);

     return XfR.ok(mainServiceImpl.querys(params));
  }

}
