package com.xforceplus.ultraman.app.jcyuanhang.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 快照格式
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public enum SnapshotFormat {

    DIRECT("direct", "直接存取"),
    FILE("file", "文件存取");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SnapshotFormat(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SnapshotFormat fromCode(String code){
        switch(code) {
            case "direct":
                return DIRECT;
            case "file":
                return FILE;
            default:
                return null;
        }
    }
}
