package com.xforceplus.ultraman.app.jczkh.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发送状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-21
 */
public enum SendStatus {

    __1("-1", "发送云平台失败"),
    _1("1", "发送云平台成功"),
    _0("0", "未发送");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SendStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendStatus fromCode(String code) {
        return Stream.of(SendStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
