package com.xforceplus.ultraman.app.jczkh.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jczkh.entity.SettlementUploadLogger;
import com.xforceplus.ultraman.app.jczkh.service.ISettlementUploadLoggerService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-06
 */
@RestController
public class SettlementUploadLoggerController {

  @Autowired
  private ISettlementUploadLoggerService settlementUploadLoggerServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementUploadLogger ${table.comment}
   * @return
   */
  @GetMapping("/settlementuploadloggers" )
  public XfR getSettlementUploadLoggers(XfPage page, SettlementUploadLogger settlementUploadLogger) {
    return XfR.ok(settlementUploadLoggerServiceImpl.page(page, Wrappers.query(settlementUploadLogger)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementuploadloggers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementUploadLoggerServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementUploadLogger ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementuploadloggers")
  public XfR save(@RequestBody SettlementUploadLogger settlementUploadLogger) {
     return XfR.ok(settlementUploadLoggerServiceImpl.save(settlementUploadLogger));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementUploadLogger ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementuploadloggers/{id}")
  public XfR putUpdate(@RequestBody SettlementUploadLogger settlementUploadLogger,@PathVariable Long id) {
      settlementUploadLogger.setId(id);
      return XfR.ok(settlementUploadLoggerServiceImpl.updateById(settlementUploadLogger));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementUploadLogger ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementuploadloggers/{id}")
  public XfR patchUpdate(@RequestBody SettlementUploadLogger settlementUploadLogger,@PathVariable Long id) {
      SettlementUploadLogger upsettlementUploadLogger = settlementUploadLoggerServiceImpl.getById(id);
      if(upsettlementUploadLogger != null){
        upsettlementUploadLogger = ObjectCopyUtils.copyProperties(settlementUploadLogger,upsettlementUploadLogger,true);
      }
      return XfR.ok(settlementUploadLoggerServiceImpl.updateById(upsettlementUploadLogger));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementuploadloggers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementUploadLoggerServiceImpl.removeById(id));
  }

  @PostMapping("/settlementuploadloggers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_upload_logger");
     params.put("request", condition);

     return XfR.ok(settlementUploadLoggerServiceImpl.querys(params));
  }

}
