package com.xforceplus.ultraman.app.ksfnoodles.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_lock
 * </p>
 *
 * @author ultraman
 * @since 2024-12-26
 */
public enum IsLock {

    LOCK("lock", "锁定"),
    UNLOCK("unlock", "未锁/解锁（默认）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    IsLock(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsLock fromCode(String code){
        switch(code) {
            case "lock":
                return LOCK;
            case "unlock":
                return UNLOCK;
            default:
                return null;
        }
    }
}
