package com.xforceplus.ultraman.app.ksfnoodles.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 康师傅方便面POS月销售数据
 * </p>
 *
 * @author ultraman
 * @since 2024-12-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MposSalesNoodles implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务主键标识
   */
  @TableField("mposId")
  private Long mposId;

  /**
   * 组织全称
   */
  private String pnall;

  /**
   * 经销商 ID
   */
  @TableField("distId")
  private Long distId;

  /**
   * 经销商编码
   */
  @TableField("distCode")
  private String distCode;

  /**
   * 经销商名称
   */
  @TableField("distName")
  private String distName;

  /**
   * 经销商类型
   */
  @TableField("distType")
  private String distType;

  /**
   * 经销商产品数量
   */
  @TableField("distProdQuantity")
  private BigDecimal distProdQuantity;

  /**
   * 经销商产品金额
   */
  @TableField("distProdAmt")
  private BigDecimal distProdAmt;

  /**
   * 统计单位数量
   */
  @TableField("countQty")
  private BigDecimal countQty;

  /**
   * 统计单位
   */
  @TableField("countUnit")
  private String countUnit;

  /**
   * 基本单位数量
   */
  @TableField("baseQty")
  private BigDecimal baseQty;

  /**
   * 基本单位
   */
  @TableField("baseUnit")
  private String baseUnit;

  /**
   * 结存日期
   */
  @TableField("transferTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime transferTime;

  /**
   * 是否含税
   */
  @TableField("taxInd")
  private String taxInd;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 销售金额
   */
  @TableField("origDistProdAmt")
  private BigDecimal origDistProdAmt;

  /**
   * 产品主数据ID
   */
  @TableField("prodId")
  private Long prodId;

  /**
   * 门店主数据ID
   */
  @TableField("storeId")
  private Long storeId;

  /**
   * 数据来源
   */
  @TableField("saleChannel")
  private String saleChannel;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("mposId", mposId);
      map.put("pnall", pnall);
      map.put("distId", distId);
      map.put("distCode", distCode);
      map.put("distName", distName);
      map.put("distType", distType);
      map.put("distProdQuantity", distProdQuantity);
      map.put("distProdAmt", distProdAmt);
      map.put("countQty", countQty);
      map.put("countUnit", countUnit);
      map.put("baseQty", baseQty);
      map.put("baseUnit", baseUnit);
      map.put("transferTime", BocpGenUtils.toTimestamp(transferTime));
      map.put("taxInd", taxInd);
      map.put("taxRate", taxRate);
      map.put("origDistProdAmt", origDistProdAmt);
      map.put("prodId", prodId);
      map.put("storeId", storeId);
      map.put("saleChannel", saleChannel);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static MposSalesNoodles fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MposSalesNoodles entity = new MposSalesNoodles();
    if(map.containsKey("mposId")) {
      Object obj = map.get("mposId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMposId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMposId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMposId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pnall")) {
      Object obj = map.get("pnall");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPnall((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distId")) {
      Object obj = map.get("distId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDistId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("distCode")) {
      Object obj = map.get("distCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distName")) {
      Object obj = map.get("distName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distType")) {
      Object obj = map.get("distType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdQuantity")) {
      Object obj = map.get("distProdQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistProdQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistProdQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistProdQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistProdQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistProdQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distProdAmt")) {
      Object obj = map.get("distProdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistProdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistProdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistProdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistProdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistProdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("countQty")) {
      Object obj = map.get("countQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCountQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCountQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCountQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCountQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCountQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("countUnit")) {
      Object obj = map.get("countUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("baseQty")) {
      Object obj = map.get("baseQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBaseQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBaseQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBaseQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBaseQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBaseQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("baseUnit")) {
      Object obj = map.get("baseUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBaseUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTransferTime(null);
      }
    }
    if(map.containsKey("taxInd")) {
      Object obj = map.get("taxInd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("origDistProdAmt")) {
      Object obj = map.get("origDistProdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrigDistProdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrigDistProdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrigDistProdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrigDistProdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrigDistProdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodId")) {
      Object obj = map.get("prodId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProdId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStoreId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStoreId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStoreId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saleChannel")) {
      Object obj = map.get("saleChannel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("mposId")) {
      Object obj = map.get("mposId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMposId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMposId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMposId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pnall")) {
      Object obj = map.get("pnall");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPnall((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distId")) {
      Object obj = map.get("distId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDistId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("distCode")) {
      Object obj = map.get("distCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distName")) {
      Object obj = map.get("distName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distType")) {
      Object obj = map.get("distType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distProdQuantity")) {
      Object obj = map.get("distProdQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDistProdQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDistProdQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDistProdQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistProdQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistProdQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("distProdAmt")) {
      Object obj = map.get("distProdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDistProdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDistProdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDistProdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistProdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistProdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("countQty")) {
      Object obj = map.get("countQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCountQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCountQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCountQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCountQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCountQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("countUnit")) {
      Object obj = map.get("countUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("baseQty")) {
      Object obj = map.get("baseQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBaseQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBaseQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBaseQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBaseQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBaseQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("baseUnit")) {
      Object obj = map.get("baseUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBaseUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTransferTime(null);
      }
    }
    if(map.containsKey("taxInd")) {
      Object obj = map.get("taxInd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("origDistProdAmt")) {
      Object obj = map.get("origDistProdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrigDistProdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrigDistProdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrigDistProdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrigDistProdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrigDistProdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("prodId")) {
      Object obj = map.get("prodId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setProdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setProdId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStoreId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStoreId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStoreId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("saleChannel")) {
      Object obj = map.get("saleChannel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
