package com.xforceplus.ultraman.app.ksfnoodles.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 康师傅方便面POS销售数据
 * </p>
 *
 * @author ultraman
 * @since 2024-12-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PosSalesNoodles implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 主键标识
   */
  @TableField("posId")
  private String posId;

  /**
   * 组织全称
   */
  private String pnall;

  /**
   * 经销商 ID
   */
  @TableField("distId")
  private String distId;

  /**
   * 经销商编码
   */
  @TableField("distCode")
  private String distCode;

  /**
   * 经销商名称
   */
  @TableField("distName")
  private String distName;

  /**
   * 经销商类型
   */
  @TableField("distType")
  private String distType;

  /**
   * 客户端编码
   */
  @TableField("clientCode")
  private String clientCode;

  /**
   * 客户端名称
   */
  @TableField("clientName")
  private String clientName;

  /**
   * 单据编码
   */
  @TableField("billCode")
  private String billCode;

  /**
   * 单据日期
   */
  @TableField("billDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billDate;

  /**
   * 库存过期日期
   */
  @TableField("txnDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime txnDate;

  /**
   * 单据类型
   */
  @TableField("billType")
  private String billType;

  /**
   * 仓库类型
   */
  @TableField("stockType")
  private String stockType;

  /**
   * 经销商门店编码
   */
  @TableField("distStoreCode")
  private String distStoreCode;

  /**
   * 经销商门店名称
   */
  @TableField("distStoreName")
  private String distStoreName;

  /**
   * 经销商产品编码
   */
  @TableField("distProdCode")
  private String distProdCode;

  /**
   * 经销商产品名称
   */
  @TableField("distProdName")
  private String distProdName;

  /**
   * 经销商产品说明
   */
  @TableField("distProdSpec")
  private String distProdSpec;

  /**
   * 经销商产品单位
   */
  @TableField("distProdUnit")
  private String distProdUnit;

  /**
   * 经销商产品条码
   */
  @TableField("distProdBarcode")
  private String distProdBarcode;

  /**
   * 产品批号
   */
  @TableField("prodNum")
  private String prodNum;

  /**
   * 送货地址
   */
  @TableField("deliveryAddr")
  private String deliveryAddr;

  /**
   * 有效期
   */
  @TableField("expireDate")
  private String expireDate;

  /**
   * 经销商产品数量
   */
  @TableField("distProdQuantity")
  private BigDecimal distProdQuantity;

  /**
   * 经销商产品价格
   */
  @TableField("distProdPrice")
  private BigDecimal distProdPrice;

  /**
   * 经销商产品金额
   */
  @TableField("distProdAmt")
  private BigDecimal distProdAmt;

  /**
   * 统计单位数量
   */
  @TableField("countQty")
  private BigDecimal countQty;

  /**
   * 统计单位
   */
  @TableField("countUnit")
  private String countUnit;

  /**
   * 基本单位数量
   */
  @TableField("baseQty")
  private BigDecimal baseQty;

  /**
   * 基本单位
   */
  @TableField("baseUnit")
  private String baseUnit;

  /**
   * 说明
   */
  @TableField("rS")
  private String rS;

  /**
   * 结存日期
   */
  @TableField("transferTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime transferTime;

  /**
   * 订单付款时间
   */
  @TableField("orderPaymentTime")
  private String orderPaymentTime;

  /**
   * 是否含税
   */
  @TableField("taxInd")
  private Long taxInd;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 销售总额
   */
  @TableField("grossSales")
  private BigDecimal grossSales;

  /**
   * 数据来源
   */
  @TableField("saleChannel")
  private String saleChannel;

  /**
   * 销售金额
   */
  @TableField("origDistProdAmt")
  private BigDecimal origDistProdAmt;

  /**
   * 原始销售数据ID
   */
  @TableField("dateId")
  private Long dateId;

  /**
   * 产品主数据ID
   */
  @TableField("prodId")
  private Long prodId;

  /**
   * 门店主数据ID
   */
  @TableField("storeId")
  private Long storeId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 采集批次
   */
  @TableField("collectionBatch")
  private String collectionBatch;

  /**
   * 业务id
   */
  @TableField("pBusinessId")
  private String pBusinessId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("posId", posId);
      map.put("pnall", pnall);
      map.put("distId", distId);
      map.put("distCode", distCode);
      map.put("distName", distName);
      map.put("distType", distType);
      map.put("clientCode", clientCode);
      map.put("clientName", clientName);
      map.put("billCode", billCode);
      map.put("billDate", BocpGenUtils.toTimestamp(billDate));
      map.put("txnDate", BocpGenUtils.toTimestamp(txnDate));
      map.put("billType", billType);
      map.put("stockType", stockType);
      map.put("distStoreCode", distStoreCode);
      map.put("distStoreName", distStoreName);
      map.put("distProdCode", distProdCode);
      map.put("distProdName", distProdName);
      map.put("distProdSpec", distProdSpec);
      map.put("distProdUnit", distProdUnit);
      map.put("distProdBarcode", distProdBarcode);
      map.put("prodNum", prodNum);
      map.put("deliveryAddr", deliveryAddr);
      map.put("expireDate", expireDate);
      map.put("distProdQuantity", distProdQuantity);
      map.put("distProdPrice", distProdPrice);
      map.put("distProdAmt", distProdAmt);
      map.put("countQty", countQty);
      map.put("countUnit", countUnit);
      map.put("baseQty", baseQty);
      map.put("baseUnit", baseUnit);
      map.put("rS", rS);
      map.put("transferTime", BocpGenUtils.toTimestamp(transferTime));
      map.put("orderPaymentTime", orderPaymentTime);
      map.put("taxInd", taxInd);
      map.put("taxRate", taxRate);
      map.put("grossSales", grossSales);
      map.put("saleChannel", saleChannel);
      map.put("origDistProdAmt", origDistProdAmt);
      map.put("dateId", dateId);
      map.put("prodId", prodId);
      map.put("storeId", storeId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("collectionBatch", collectionBatch);
      map.put("pBusinessId", pBusinessId);

      return map;
  }

  public static PosSalesNoodles fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PosSalesNoodles entity = new PosSalesNoodles();
    if(map.containsKey("posId")) {
      Object obj = map.get("posId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pnall")) {
      Object obj = map.get("pnall");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPnall((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distId")) {
      Object obj = map.get("distId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distCode")) {
      Object obj = map.get("distCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distName")) {
      Object obj = map.get("distName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distType")) {
      Object obj = map.get("distType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clientCode")) {
      Object obj = map.get("clientCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClientCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clientName")) {
      Object obj = map.get("clientName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClientName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billCode")) {
      Object obj = map.get("billCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billDate")) {
      Object obj = map.get("billDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillDate(null);
      }
    }
    if(map.containsKey("txnDate")) {
      Object obj = map.get("txnDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTxnDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTxnDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTxnDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTxnDate(null);
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stockType")) {
      Object obj = map.get("stockType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStockType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distStoreCode")) {
      Object obj = map.get("distStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distStoreName")) {
      Object obj = map.get("distStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdCode")) {
      Object obj = map.get("distProdCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdName")) {
      Object obj = map.get("distProdName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdSpec")) {
      Object obj = map.get("distProdSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdUnit")) {
      Object obj = map.get("distProdUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdBarcode")) {
      Object obj = map.get("distProdBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodNum")) {
      Object obj = map.get("prodNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryAddr")) {
      Object obj = map.get("deliveryAddr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expireDate")) {
      Object obj = map.get("expireDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpireDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdQuantity")) {
      Object obj = map.get("distProdQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistProdQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistProdQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistProdQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistProdQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistProdQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distProdPrice")) {
      Object obj = map.get("distProdPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistProdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistProdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistProdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistProdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistProdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distProdAmt")) {
      Object obj = map.get("distProdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistProdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistProdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistProdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistProdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistProdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("countQty")) {
      Object obj = map.get("countQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCountQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCountQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCountQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCountQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCountQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("countUnit")) {
      Object obj = map.get("countUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("baseQty")) {
      Object obj = map.get("baseQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBaseQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBaseQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBaseQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBaseQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBaseQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("baseUnit")) {
      Object obj = map.get("baseUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBaseUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rS")) {
      Object obj = map.get("rS");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRS((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTransferTime(null);
      }
    }
    if(map.containsKey("orderPaymentTime")) {
      Object obj = map.get("orderPaymentTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderPaymentTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInd")) {
      Object obj = map.get("taxInd");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxInd((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxInd(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxInd(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("grossSales")) {
      Object obj = map.get("grossSales");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGrossSales((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGrossSales(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGrossSales(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGrossSales(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGrossSales(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("saleChannel")) {
      Object obj = map.get("saleChannel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origDistProdAmt")) {
      Object obj = map.get("origDistProdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrigDistProdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrigDistProdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrigDistProdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrigDistProdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrigDistProdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("dateId")) {
      Object obj = map.get("dateId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDateId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDateId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDateId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("prodId")) {
      Object obj = map.get("prodId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProdId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStoreId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStoreId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStoreId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("posId")) {
      Object obj = map.get("posId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pnall")) {
      Object obj = map.get("pnall");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPnall((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distId")) {
      Object obj = map.get("distId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distCode")) {
      Object obj = map.get("distCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distName")) {
      Object obj = map.get("distName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distType")) {
      Object obj = map.get("distType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("clientCode")) {
      Object obj = map.get("clientCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClientCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("clientName")) {
      Object obj = map.get("clientName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClientName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billCode")) {
      Object obj = map.get("billCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billDate")) {
      Object obj = map.get("billDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillDate(null);
      }
    }
    if(map.containsKey("txnDate")) {
      Object obj = map.get("txnDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTxnDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTxnDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTxnDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTxnDate(null);
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("stockType")) {
      Object obj = map.get("stockType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStockType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distStoreCode")) {
      Object obj = map.get("distStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distStoreName")) {
      Object obj = map.get("distStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distProdCode")) {
      Object obj = map.get("distProdCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistProdCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distProdName")) {
      Object obj = map.get("distProdName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistProdName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distProdSpec")) {
      Object obj = map.get("distProdSpec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistProdSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distProdUnit")) {
      Object obj = map.get("distProdUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistProdUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distProdBarcode")) {
      Object obj = map.get("distProdBarcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistProdBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prodNum")) {
      Object obj = map.get("prodNum");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProdNum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryAddr")) {
      Object obj = map.get("deliveryAddr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryAddr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expireDate")) {
      Object obj = map.get("expireDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpireDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distProdQuantity")) {
      Object obj = map.get("distProdQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDistProdQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDistProdQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDistProdQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistProdQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistProdQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("distProdPrice")) {
      Object obj = map.get("distProdPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDistProdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDistProdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDistProdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistProdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistProdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("distProdAmt")) {
      Object obj = map.get("distProdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDistProdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDistProdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDistProdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistProdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistProdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("countQty")) {
      Object obj = map.get("countQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCountQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCountQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCountQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCountQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCountQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("countUnit")) {
      Object obj = map.get("countUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("baseQty")) {
      Object obj = map.get("baseQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBaseQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBaseQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBaseQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBaseQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBaseQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("baseUnit")) {
      Object obj = map.get("baseUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBaseUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rS")) {
      Object obj = map.get("rS");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRS((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTransferTime(null);
      }
    }
    if(map.containsKey("orderPaymentTime")) {
      Object obj = map.get("orderPaymentTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderPaymentTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInd")) {
      Object obj = map.get("taxInd");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTaxInd((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxInd(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxInd(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("grossSales")) {
      Object obj = map.get("grossSales");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGrossSales((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGrossSales(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGrossSales(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGrossSales(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGrossSales(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("saleChannel")) {
      Object obj = map.get("saleChannel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origDistProdAmt")) {
      Object obj = map.get("origDistProdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrigDistProdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrigDistProdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrigDistProdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrigDistProdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrigDistProdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("dateId")) {
      Object obj = map.get("dateId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDateId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDateId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDateId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("prodId")) {
      Object obj = map.get("prodId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setProdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setProdId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStoreId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStoreId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStoreId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
  }
}
