package com.xforceplus.ultraman.app.ksfnoodles.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * interface_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-12
 */
public enum InterfaceStatus {

    FALSE("false", "否"),
    TRUE("true", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InterfaceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InterfaceStatus fromCode(String code) {
        return Stream.of(InterfaceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
