package com.xforceplus.ultraman.app.ksfnoodles.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_enabled
 * </p>
 *
 * @author ultraman
 * @since 2024-12-12
 */
public enum IsEnabled {

    ENABLED("enabled", "开启（默认）"),
    DISABLED("disabled", "关闭/停止");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsEnabled(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsEnabled fromCode(String code) {
        return Stream.of(IsEnabled.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
