package com.xforceplus.ultraman.app.ksfnoodles.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * ir_stock_noodles
 * </p>
 *
 * @author ultraman
 * @since 2024-12-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class IrStockNoodles implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 主键标识
   */
  private String irId;
  /**
   * 组织全称
   */
  private String pnall;
  /**
   * KA名称
   */
  private String distName;
  /**
   * KA编码
   */
  private String distCode;
  /**
   * 客户端编码
   */
  private String clientCode;
  /**
   * 库存日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime stockDate;
  /**
   * 仓库类型
   */
  private String stockType;
  /**
   * KA产品编码
   */
  private String distProdCode;
  /**
   * KA产品条码
   */
  private String distProdBarcode;
  /**
   * KA产品名称
   */
  private String distProdName;
  /**
   * KA产品说明
   */
  private String distProdSpec;
  /**
   * KA产品单位
   */
  private String distProdUnit;
  /**
   * 产品编码
   */
  private String prodCode;
  /**
   * 产品名称
   */
  private String prodName;
  /**
   * KA产品数量
   */
  private BigDecimal distProdQuantity;
  /**
   * KA产品价格
   */
  private BigDecimal distProdPrice;
  /**
   * KA产品金额
   */
  private BigDecimal distProdAmount;
  /**
   * 更新日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updated;
  /**
   * 统计单位
   */
  private String countUnit;
  /**
   * 统计单位数量
   */
  private BigDecimal countQty;
  /**
   * 删除日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deleteTime;
  /**
   * 状态
   */
  private String state;
  /**
   * 统计单位金额
   */
  private BigDecimal grossSales;
  /**
   * 产品批号
   */
  private String prodNum;
  /**
   * 说明
   */
  private String remark;
  /**
   * 产品品牌
   */
  private String prodBrandName;
  /**
   * 产品品类
   */
  private String prodClassName;
  /**
   * 产品条码
   */
  private String prodBarcode;
  /**
   * 产品类型
   */
  private String prodTypeName;
  /**
   * KA计算金额
   */
  private BigDecimal distCalculateAmount;
  /**
   * 产品价格
   */
  private BigDecimal prodPrice;
  /**
   * 产品过期日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime prodManufacturingDate;
  /**
   * 基本单位
   */
  private String baseUnit;
  /**
   * 基本单位数量
   */
  private BigDecimal baseQty;
  /**
   * 有效期
   */
  private String expireDate;
  /**
   * KA类型
   */
  private String distType;
  /**
   * 产品线
   */
  private String prodLine;
  /**
   * 结存日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime transferTime;
  /**
   * 产品主数据ID
   */
  private Long prodId;
  /**
   * 门店主数据ID
   */
  private Long storeId;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("irId", irId);
      map.put("pnall", pnall);
      map.put("distName", distName);
      map.put("distCode", distCode);
      map.put("clientCode", clientCode);
      map.put("stockDate", BocpGenUtils.toTimestamp(stockDate));
      map.put("stockType", stockType);
      map.put("distProdCode", distProdCode);
      map.put("distProdBarcode", distProdBarcode);
      map.put("distProdName", distProdName);
      map.put("distProdSpec", distProdSpec);
      map.put("distProdUnit", distProdUnit);
      map.put("prodCode", prodCode);
      map.put("prodName", prodName);
      map.put("distProdQuantity", distProdQuantity);
      map.put("distProdPrice", distProdPrice);
      map.put("distProdAmount", distProdAmount);
      map.put("updated", BocpGenUtils.toTimestamp(updated));
      map.put("countUnit", countUnit);
      map.put("countQty", countQty);
      map.put("deleteTime", BocpGenUtils.toTimestamp(deleteTime));
      map.put("state", state);
      map.put("grossSales", grossSales);
      map.put("prodNum", prodNum);
      map.put("remark", remark);
      map.put("prodBrandName", prodBrandName);
      map.put("prodClassName", prodClassName);
      map.put("prodBarcode", prodBarcode);
      map.put("prodTypeName", prodTypeName);
      map.put("distCalculateAmount", distCalculateAmount);
      map.put("prodPrice", prodPrice);
      map.put("prodManufacturingDate", BocpGenUtils.toTimestamp(prodManufacturingDate));
      map.put("baseUnit", baseUnit);
      map.put("baseQty", baseQty);
      map.put("expireDate", expireDate);
      map.put("distType", distType);
      map.put("prodLine", prodLine);
      map.put("transferTime", BocpGenUtils.toTimestamp(transferTime));
      map.put("prodId", prodId);
      map.put("storeId", storeId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static IrStockNoodles fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    IrStockNoodles entity = new IrStockNoodles();

    if(map.containsKey("irId")) {
      Object obj = map.get("irId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIrId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pnall")) {
      Object obj = map.get("pnall");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPnall((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distName")) {
      Object obj = map.get("distName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distCode")) {
      Object obj = map.get("distCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clientCode")) {
      Object obj = map.get("clientCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClientCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stockDate")) {
      Object obj = map.get("stockDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStockDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStockDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStockDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStockDate(null);
      }
    }
    if(map.containsKey("stockType")) {
      Object obj = map.get("stockType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStockType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdCode")) {
      Object obj = map.get("distProdCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdBarcode")) {
      Object obj = map.get("distProdBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdName")) {
      Object obj = map.get("distProdName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdSpec")) {
      Object obj = map.get("distProdSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdUnit")) {
      Object obj = map.get("distProdUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistProdUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodCode")) {
      Object obj = map.get("prodCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodName")) {
      Object obj = map.get("prodName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdQuantity")) {
      Object obj = map.get("distProdQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistProdQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistProdQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistProdQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistProdQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistProdQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distProdPrice")) {
      Object obj = map.get("distProdPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistProdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistProdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistProdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistProdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistProdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distProdAmount")) {
      Object obj = map.get("distProdAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistProdAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistProdAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistProdAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistProdAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistProdAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("updated")) {
      Object obj = map.get("updated");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdated(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdated((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdated(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdated(null);
      }
    }
    if(map.containsKey("countUnit")) {
      Object obj = map.get("countUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("countQty")) {
      Object obj = map.get("countQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCountQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCountQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCountQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCountQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCountQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deleteTime")) {
      Object obj = map.get("deleteTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeleteTime(null);
      }
    }
    if(map.containsKey("state")) {
      Object obj = map.get("state");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grossSales")) {
      Object obj = map.get("grossSales");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGrossSales((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGrossSales(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGrossSales(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGrossSales(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGrossSales(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodNum")) {
      Object obj = map.get("prodNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodBrandName")) {
      Object obj = map.get("prodBrandName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdBrandName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodClassName")) {
      Object obj = map.get("prodClassName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdClassName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodBarcode")) {
      Object obj = map.get("prodBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTypeName")) {
      Object obj = map.get("prodTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distCalculateAmount")) {
      Object obj = map.get("distCalculateAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistCalculateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistCalculateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistCalculateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistCalculateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistCalculateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodPrice")) {
      Object obj = map.get("prodPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodManufacturingDate")) {
      Object obj = map.get("prodManufacturingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProdManufacturingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setProdManufacturingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdManufacturingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setProdManufacturingDate(null);
      }
    }
    if(map.containsKey("baseUnit")) {
      Object obj = map.get("baseUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBaseUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("baseQty")) {
      Object obj = map.get("baseQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBaseQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBaseQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBaseQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBaseQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBaseQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expireDate")) {
      Object obj = map.get("expireDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpireDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distType")) {
      Object obj = map.get("distType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodLine")) {
      Object obj = map.get("prodLine");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdLine((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTransferTime(null);
      }
    }
    if(map.containsKey("prodId")) {
      Object obj = map.get("prodId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setProdId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStoreId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStoreId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStoreId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("irId")) {
      Object obj = map.get("irId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIrId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pnall")) {
      Object obj = map.get("pnall");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPnall((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distName")) {
      Object obj = map.get("distName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distCode")) {
      Object obj = map.get("distCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clientCode")) {
      Object obj = map.get("clientCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setClientCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stockDate")) {
      Object obj = map.get("stockDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStockDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStockDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStockDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStockDate(null);
      }
    }
    if(map.containsKey("stockType")) {
      Object obj = map.get("stockType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStockType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdCode")) {
      Object obj = map.get("distProdCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistProdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdBarcode")) {
      Object obj = map.get("distProdBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistProdBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdName")) {
      Object obj = map.get("distProdName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistProdName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdSpec")) {
      Object obj = map.get("distProdSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistProdSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdUnit")) {
      Object obj = map.get("distProdUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistProdUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodCode")) {
      Object obj = map.get("prodCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodName")) {
      Object obj = map.get("prodName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distProdQuantity")) {
      Object obj = map.get("distProdQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDistProdQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDistProdQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDistProdQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDistProdQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDistProdQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distProdPrice")) {
      Object obj = map.get("distProdPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDistProdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDistProdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDistProdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDistProdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDistProdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distProdAmount")) {
      Object obj = map.get("distProdAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDistProdAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDistProdAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDistProdAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDistProdAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDistProdAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("updated")) {
      Object obj = map.get("updated");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdated(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdated((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdated(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdated(null);
      }
    }
    if(map.containsKey("countUnit")) {
      Object obj = map.get("countUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCountUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("countQty")) {
      Object obj = map.get("countQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCountQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCountQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCountQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCountQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCountQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deleteTime")) {
      Object obj = map.get("deleteTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeleteTime(null);
      }
    }
    if(map.containsKey("state")) {
      Object obj = map.get("state");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grossSales")) {
      Object obj = map.get("grossSales");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGrossSales((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGrossSales(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGrossSales(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGrossSales(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGrossSales(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodNum")) {
      Object obj = map.get("prodNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodBrandName")) {
      Object obj = map.get("prodBrandName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdBrandName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodClassName")) {
      Object obj = map.get("prodClassName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdClassName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodBarcode")) {
      Object obj = map.get("prodBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTypeName")) {
      Object obj = map.get("prodTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distCalculateAmount")) {
      Object obj = map.get("distCalculateAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDistCalculateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDistCalculateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDistCalculateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDistCalculateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDistCalculateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodPrice")) {
      Object obj = map.get("prodPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setProdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setProdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setProdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setProdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodManufacturingDate")) {
      Object obj = map.get("prodManufacturingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setProdManufacturingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setProdManufacturingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProdManufacturingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setProdManufacturingDate(null);
      }
    }
    if(map.containsKey("baseUnit")) {
      Object obj = map.get("baseUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBaseUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("baseQty")) {
      Object obj = map.get("baseQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBaseQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBaseQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBaseQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBaseQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBaseQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expireDate")) {
      Object obj = map.get("expireDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExpireDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distType")) {
      Object obj = map.get("distType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodLine")) {
      Object obj = map.get("prodLine");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdLine((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTransferTime(null);
      }
    }
    if(map.containsKey("prodId")) {
      Object obj = map.get("prodId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setProdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setProdId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStoreId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStoreId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setStoreId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
