package com.xforceplus.ultraman.app.ksfnoodles.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * mdm_product
 * </p>
 *
 * @author ultraman
 * @since 2024-12-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MdmProduct implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 主键ID
   */
  private String prodId;
  /**
   * 产品编码
   */
  private String prodCode;
  /**
   * 外部编码
   */
  private String extCode;
  /**
   * 上级产品编码
   */
  private String parentProdCode;
  /**
   * 上级产品名称
   */
  private String parentProdName;
  /**
   * 产品名称
   */
  private String prodName;
  /**
   * 英文名称
   */
  private String prodNameEn;
  /**
   * 产品别称
   */
  private String prodAlias;
  /**
   * 产品单价（不含税）
   */
  private BigDecimal prodPrice;
  /**
   * 单价单位
   */
  private String prodPriceUnit;
  /**
   * 产品条码
   */
  private String prodBarcode;
  /**
   * 产品PC条码
   */
  private String prodPcBarcode;
  /**
   * 产品品牌编码
   */
  private String brandCode;
  /**
   * 产品品牌名称
   */
  private String brandName;
  /**
   * 产品品类（系）编码
   */
  private String typeCode;
  /**
   * 产品品类（系）名称
   */
  private String typeName;
  /**
   * 包装类型编码
   */
  private String packCode;
  /**
   * 包装类型名称
   */
  private String packName;
  /**
   * 产品线编码
   */
  private String otherCode;
  /**
   * 产品线名称
   */
  private String otherName;
  /**
   * 产品结构编码
   */
  private String prodStruCode;
  /**
   * 产品结构名称
   */
  private String prodStruName;
  /**
   * 生命周期状态(是|否)
   */
  private String state;
  /**
   * 包装规格
   */
  private String prodSpec;
  /**
   * 统计单位
   */
  private String prodCountUnit;
  /**
   * 基本单位
   */
  private String prodBaseUnit;
  /**
   * 净重(公斤/箱)
   */
  private BigDecimal prodWeight;
  /**
   * 净重单位
   */
  private String prodWeightUnit;
  /**
   * 最小计量单位重量(g)
   */
  private BigDecimal prodMinWeight;
  /**
   * 过渡包装数
   */
  private BigDecimal prodContent;
  /**
   * 最小包装数
   */
  private BigDecimal prodMinContent;
  /**
   * 体积
   */
  private BigDecimal volume;
  /**
   * 体积单位
   */
  private String volumeUnit;
  /**
   * 促销装编码
   */
  private String promotionPackCode;
  /**
   * 促销装名称
   */
  private String promotionPackName;
  /**
   * 税率(销售)
   */
  private BigDecimal taxRate;
  /**
   * 业务类型编码
   */
  private String businessTypeCode;
  /**
   * 业务类型名称
   */
  private String businessTypeName;
  /**
   * 产品标签编码
   */
  private String prodTag;
  /**
   * 产品标签名称
   */
  private String prodTagName;
  /**
   * 产品类型编码
   */
  private String prodTypeCode;
  /**
   * 产品类型名称
   */
  private String prodTypeName;
  /**
   * 产品口味
   */
  private String memo1;
  /**
   * 属性2
   */
  private String memo2;
  /**
   * 更新时间（格式：yyyy-MM-dd HH:mm:ss）
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updated;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("prodId", prodId);
      map.put("prodCode", prodCode);
      map.put("extCode", extCode);
      map.put("parentProdCode", parentProdCode);
      map.put("parentProdName", parentProdName);
      map.put("prodName", prodName);
      map.put("prodNameEn", prodNameEn);
      map.put("prodAlias", prodAlias);
      map.put("prodPrice", prodPrice);
      map.put("prodPriceUnit", prodPriceUnit);
      map.put("prodBarcode", prodBarcode);
      map.put("prodPcBarcode", prodPcBarcode);
      map.put("brandCode", brandCode);
      map.put("brandName", brandName);
      map.put("typeCode", typeCode);
      map.put("typeName", typeName);
      map.put("packCode", packCode);
      map.put("packName", packName);
      map.put("otherCode", otherCode);
      map.put("otherName", otherName);
      map.put("prodStruCode", prodStruCode);
      map.put("prodStruName", prodStruName);
      map.put("state", state);
      map.put("prodSpec", prodSpec);
      map.put("prodCountUnit", prodCountUnit);
      map.put("prodBaseUnit", prodBaseUnit);
      map.put("prodWeight", prodWeight);
      map.put("prodWeightUnit", prodWeightUnit);
      map.put("prodMinWeight", prodMinWeight);
      map.put("prodContent", prodContent);
      map.put("prodMinContent", prodMinContent);
      map.put("volume", volume);
      map.put("volumeUnit", volumeUnit);
      map.put("promotionPackCode", promotionPackCode);
      map.put("promotionPackName", promotionPackName);
      map.put("taxRate", taxRate);
      map.put("businessTypeCode", businessTypeCode);
      map.put("businessTypeName", businessTypeName);
      map.put("prodTag", prodTag);
      map.put("prodTagName", prodTagName);
      map.put("prodTypeCode", prodTypeCode);
      map.put("prodTypeName", prodTypeName);
      map.put("memo1", memo1);
      map.put("memo2", memo2);
      map.put("updated", BocpGenUtils.toTimestamp(updated));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static MdmProduct fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    MdmProduct entity = new MdmProduct();

    if(map.containsKey("prodId")) {
      Object obj = map.get("prodId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodCode")) {
      Object obj = map.get("prodCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extCode")) {
      Object obj = map.get("extCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentProdCode")) {
      Object obj = map.get("parentProdCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParentProdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentProdName")) {
      Object obj = map.get("parentProdName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParentProdName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodName")) {
      Object obj = map.get("prodName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodNameEn")) {
      Object obj = map.get("prodNameEn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdNameEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodAlias")) {
      Object obj = map.get("prodAlias");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdAlias((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodPrice")) {
      Object obj = map.get("prodPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodPriceUnit")) {
      Object obj = map.get("prodPriceUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdPriceUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodBarcode")) {
      Object obj = map.get("prodBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodPcBarcode")) {
      Object obj = map.get("prodPcBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdPcBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brandCode")) {
      Object obj = map.get("brandCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrandCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brandName")) {
      Object obj = map.get("brandName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrandName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("typeCode")) {
      Object obj = map.get("typeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("typeName")) {
      Object obj = map.get("typeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packCode")) {
      Object obj = map.get("packCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packName")) {
      Object obj = map.get("packName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otherCode")) {
      Object obj = map.get("otherCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOtherCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otherName")) {
      Object obj = map.get("otherName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOtherName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodStruCode")) {
      Object obj = map.get("prodStruCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdStruCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodStruName")) {
      Object obj = map.get("prodStruName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdStruName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("state")) {
      Object obj = map.get("state");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodSpec")) {
      Object obj = map.get("prodSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodCountUnit")) {
      Object obj = map.get("prodCountUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdCountUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodBaseUnit")) {
      Object obj = map.get("prodBaseUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdBaseUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodWeight")) {
      Object obj = map.get("prodWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProdWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProdWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProdWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProdWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodWeightUnit")) {
      Object obj = map.get("prodWeightUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdWeightUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodMinWeight")) {
      Object obj = map.get("prodMinWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProdMinWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProdMinWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProdMinWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdMinWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProdMinWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodContent")) {
      Object obj = map.get("prodContent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProdContent((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProdContent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProdContent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdContent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProdContent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodMinContent")) {
      Object obj = map.get("prodMinContent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProdMinContent((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProdMinContent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProdMinContent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProdMinContent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProdMinContent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVolume((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVolume(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVolume(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVolume(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVolume(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolumeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promotionPackCode")) {
      Object obj = map.get("promotionPackCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromotionPackCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promotionPackName")) {
      Object obj = map.get("promotionPackName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromotionPackName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeCode")) {
      Object obj = map.get("businessTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeName")) {
      Object obj = map.get("businessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTag")) {
      Object obj = map.get("prodTag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTagName")) {
      Object obj = map.get("prodTagName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdTagName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTypeCode")) {
      Object obj = map.get("prodTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTypeName")) {
      Object obj = map.get("prodTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProdTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memo1")) {
      Object obj = map.get("memo1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMemo1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memo2")) {
      Object obj = map.get("memo2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMemo2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updated")) {
      Object obj = map.get("updated");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdated(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdated((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdated(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdated(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("prodId")) {
      Object obj = map.get("prodId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodCode")) {
      Object obj = map.get("prodCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extCode")) {
      Object obj = map.get("extCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentProdCode")) {
      Object obj = map.get("parentProdCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setParentProdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentProdName")) {
      Object obj = map.get("parentProdName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setParentProdName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodName")) {
      Object obj = map.get("prodName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodNameEn")) {
      Object obj = map.get("prodNameEn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdNameEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodAlias")) {
      Object obj = map.get("prodAlias");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdAlias((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodPrice")) {
      Object obj = map.get("prodPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setProdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setProdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setProdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setProdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodPriceUnit")) {
      Object obj = map.get("prodPriceUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdPriceUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodBarcode")) {
      Object obj = map.get("prodBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodPcBarcode")) {
      Object obj = map.get("prodPcBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdPcBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brandCode")) {
      Object obj = map.get("brandCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBrandCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brandName")) {
      Object obj = map.get("brandName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBrandName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("typeCode")) {
      Object obj = map.get("typeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("typeName")) {
      Object obj = map.get("typeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packCode")) {
      Object obj = map.get("packCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packName")) {
      Object obj = map.get("packName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otherCode")) {
      Object obj = map.get("otherCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOtherCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otherName")) {
      Object obj = map.get("otherName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOtherName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodStruCode")) {
      Object obj = map.get("prodStruCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdStruCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodStruName")) {
      Object obj = map.get("prodStruName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdStruName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("state")) {
      Object obj = map.get("state");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodSpec")) {
      Object obj = map.get("prodSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodCountUnit")) {
      Object obj = map.get("prodCountUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdCountUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodBaseUnit")) {
      Object obj = map.get("prodBaseUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdBaseUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodWeight")) {
      Object obj = map.get("prodWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setProdWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setProdWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setProdWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProdWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setProdWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodWeightUnit")) {
      Object obj = map.get("prodWeightUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdWeightUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodMinWeight")) {
      Object obj = map.get("prodMinWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setProdMinWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setProdMinWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setProdMinWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProdMinWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setProdMinWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodContent")) {
      Object obj = map.get("prodContent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setProdContent((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setProdContent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setProdContent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProdContent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setProdContent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prodMinContent")) {
      Object obj = map.get("prodMinContent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setProdMinContent((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setProdMinContent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setProdMinContent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProdMinContent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setProdMinContent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setVolume((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setVolume(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setVolume(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setVolume(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setVolume(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVolumeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promotionPackCode")) {
      Object obj = map.get("promotionPackCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPromotionPackCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promotionPackName")) {
      Object obj = map.get("promotionPackName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPromotionPackName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeCode")) {
      Object obj = map.get("businessTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeName")) {
      Object obj = map.get("businessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTag")) {
      Object obj = map.get("prodTag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTagName")) {
      Object obj = map.get("prodTagName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdTagName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTypeCode")) {
      Object obj = map.get("prodTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prodTypeName")) {
      Object obj = map.get("prodTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProdTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memo1")) {
      Object obj = map.get("memo1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMemo1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memo2")) {
      Object obj = map.get("memo2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMemo2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updated")) {
      Object obj = map.get("updated");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdated(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdated((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdated(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdated(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
