package com.xforceplus.ultraman.app.ksfnoodles.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_lock
 * </p>
 *
 * @author ultraman
 * @since 2024-12-12
 */
public enum IsLock {

    LOCK("lock", "锁定"),
    UNLOCK("unlock", "未锁/解锁（默认）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsLock(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsLock fromCode(String code) {
        return Stream.of(IsLock.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
