package com.xforceplus.ultraman.app.ksfnoodles.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_tax_ind
 * </p>
 *
 * @author ultraman
 * @since 2024-12-12
 */
public enum IsTaxInd {

    _1("1", "含税"),
    _0("0", "未税");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsTaxInd(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsTaxInd fromCode(String code) {
        return Stream.of(IsTaxInd.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
