package com.xforceplus.ultraman.app.ksfnoodles.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_valid
 * </p>
 *
 * @author ultraman
 * @since 2024-12-12
 */
public enum IsValid {

    VALID("valid", "有效（默认）"),
    INVALID("invalid", "无效");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsValid(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsValid fromCode(String code) {
        return Stream.of(IsValid.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
