package com.xforceplus.ultraman.app.ksfnoodles.metadata.validator;

import com.xforceplus.ultraman.app.ksfnoodles.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.ksfnoodles.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-12-12
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(DownStatus.class)) {
            isValid = null != DownStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DownStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsValid.class)) {
            isValid = null != IsValid.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsValid.class.getSimpleName());
            }
        }
        if(clazz.equals(InterfaceStatus.class)) {
            isValid = null != InterfaceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InterfaceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsLock.class)) {
            isValid = null != IsLock.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsLock.class.getSimpleName());
            }
        }
        if(clazz.equals(IsTaxInd.class)) {
            isValid = null != IsTaxInd.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsTaxInd.class.getSimpleName());
            }
        }
        if(clazz.equals(IsEnabled.class)) {
            isValid = null != IsEnabled.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsEnabled.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
