package com.xforceplus.ultraman.app.ksfnoodles.metadata.validator;

import com.xforceplus.ultraman.app.ksfnoodles.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.ksfnoodles.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-12-12
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(DownStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DownStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DownStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsValid.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsValid.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsValid.class.getSimpleName());
            }
        }
        if(clazz.equals(InterfaceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InterfaceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InterfaceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsLock.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsLock.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsLock.class.getSimpleName());
            }
        }
        if(clazz.equals(IsTaxInd.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsTaxInd.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsTaxInd.class.getSimpleName());
            }
        }
        if(clazz.equals(IsEnabled.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsEnabled.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsEnabled.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
