package com.xforceplus.ultraman.app.ksfnoodles.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ksfnoodles.entity.IrStockNoodles;
import com.xforceplus.ultraman.app.ksfnoodles.service.IIrStockNoodlesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 康师傅方便面库存数据前端控制器
 *
 * @author ultraman
 * @date 2024-12-25
 */
@RestController
public class IrStockNoodlesController {

  @Autowired
  private IIrStockNoodlesService irStockNoodlesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param irStockNoodles 康师傅方便面库存数据
   * @return
   */
  @GetMapping("/irstocknoodless" )
  public XfR getIrStockNoodless(XfPage page, IrStockNoodles irStockNoodles) {
    return XfR.ok(irStockNoodlesServiceImpl.page(page, Wrappers.query(irStockNoodles)));
  }

  /**
   * 通过id查询康师傅方便面库存数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/irstocknoodless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(irStockNoodlesServiceImpl.getById(id));
  }

  /**
   * 新增康师傅方便面库存数据
   * @param irStockNoodles 康师傅方便面库存数据
   * @return XfR
   */
  @PostMapping("/irstocknoodless")
  public XfR save(@RequestBody IrStockNoodles irStockNoodles) {
     return XfR.ok(irStockNoodlesServiceImpl.save(irStockNoodles));
  }

  /**
   * 修改-传入修改后的全部数据康师傅方便面库存数据
   * @param irStockNoodles 康师傅方便面库存数据
   * @return XfR
   */
  @PutMapping("/irstocknoodless/{id}")
  public XfR putUpdate(@RequestBody IrStockNoodles irStockNoodles,@PathVariable Long id) {
      irStockNoodles.setId(id);
      return XfR.ok(irStockNoodlesServiceImpl.updateById(irStockNoodles));
  }

  /**
   * 修改-传入修改的数据康师傅方便面库存数据
   * @param irStockNoodles 康师傅方便面库存数据
   * @return XfR
   */
  @PatchMapping("/irstocknoodless/{id}")
  public XfR patchUpdate(@RequestBody IrStockNoodles irStockNoodles,@PathVariable Long id) {
      IrStockNoodles upirStockNoodles = irStockNoodlesServiceImpl.getById(id);
      if(upirStockNoodles != null){
        upirStockNoodles = ObjectCopyUtils.copyProperties(irStockNoodles,upirStockNoodles,true);
      }
      return XfR.ok(irStockNoodlesServiceImpl.updateById(upirStockNoodles));
  }

  /**
   * 通过id删除康师傅方便面库存数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/irstocknoodless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(irStockNoodlesServiceImpl.removeById(id));
  }

  @PostMapping("/irstocknoodless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ir_stock_noodles");
     params.put("request", condition);

     return XfR.ok(irStockNoodlesServiceImpl.querys(params));
  }

}
