package com.xforceplus.ultraman.app.ksfnoodles.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ksfnoodles.entity.MdmProduct;
import com.xforceplus.ultraman.app.ksfnoodles.service.IMdmProductService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 康师傅方便面产品主数据前端控制器
 *
 * @author ultraman
 * @date 2024-12-25
 */
@RestController
public class MdmProductController {

  @Autowired
  private IMdmProductService mdmProductServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mdmProduct 康师傅方便面产品主数据
   * @return
   */
  @GetMapping("/mdmproducts" )
  public XfR getMdmProducts(XfPage page, MdmProduct mdmProduct) {
    return XfR.ok(mdmProductServiceImpl.page(page, Wrappers.query(mdmProduct)));
  }

  /**
   * 通过id查询康师傅方便面产品主数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/mdmproducts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mdmProductServiceImpl.getById(id));
  }

  /**
   * 新增康师傅方便面产品主数据
   * @param mdmProduct 康师傅方便面产品主数据
   * @return XfR
   */
  @PostMapping("/mdmproducts")
  public XfR save(@RequestBody MdmProduct mdmProduct) {
     return XfR.ok(mdmProductServiceImpl.save(mdmProduct));
  }

  /**
   * 修改-传入修改后的全部数据康师傅方便面产品主数据
   * @param mdmProduct 康师傅方便面产品主数据
   * @return XfR
   */
  @PutMapping("/mdmproducts/{id}")
  public XfR putUpdate(@RequestBody MdmProduct mdmProduct,@PathVariable Long id) {
      mdmProduct.setId(id);
      return XfR.ok(mdmProductServiceImpl.updateById(mdmProduct));
  }

  /**
   * 修改-传入修改的数据康师傅方便面产品主数据
   * @param mdmProduct 康师傅方便面产品主数据
   * @return XfR
   */
  @PatchMapping("/mdmproducts/{id}")
  public XfR patchUpdate(@RequestBody MdmProduct mdmProduct,@PathVariable Long id) {
      MdmProduct upmdmProduct = mdmProductServiceImpl.getById(id);
      if(upmdmProduct != null){
        upmdmProduct = ObjectCopyUtils.copyProperties(mdmProduct,upmdmProduct,true);
      }
      return XfR.ok(mdmProductServiceImpl.updateById(upmdmProduct));
  }

  /**
   * 通过id删除康师傅方便面产品主数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mdmproducts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mdmProductServiceImpl.removeById(id));
  }

  @PostMapping("/mdmproducts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mdm_product");
     params.put("request", condition);

     return XfR.ok(mdmProductServiceImpl.querys(params));
  }

}
