package com.xforceplus.ultraman.app.ksfnoodles.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ksfnoodles.entity.PosSalesNoodles;
import com.xforceplus.ultraman.app.ksfnoodles.service.IPosSalesNoodlesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 康师傅方便面POS销售数据前端控制器
 *
 * @author ultraman
 * @date 2024-12-25
 */
@RestController
public class PosSalesNoodlesController {

  @Autowired
  private IPosSalesNoodlesService posSalesNoodlesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param posSalesNoodles 康师傅方便面POS销售数据
   * @return
   */
  @GetMapping("/possalesnoodless" )
  public XfR getPosSalesNoodless(XfPage page, PosSalesNoodles posSalesNoodles) {
    return XfR.ok(posSalesNoodlesServiceImpl.page(page, Wrappers.query(posSalesNoodles)));
  }

  /**
   * 通过id查询康师傅方便面POS销售数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/possalesnoodless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(posSalesNoodlesServiceImpl.getById(id));
  }

  /**
   * 新增康师傅方便面POS销售数据
   * @param posSalesNoodles 康师傅方便面POS销售数据
   * @return XfR
   */
  @PostMapping("/possalesnoodless")
  public XfR save(@RequestBody PosSalesNoodles posSalesNoodles) {
     return XfR.ok(posSalesNoodlesServiceImpl.save(posSalesNoodles));
  }

  /**
   * 修改-传入修改后的全部数据康师傅方便面POS销售数据
   * @param posSalesNoodles 康师傅方便面POS销售数据
   * @return XfR
   */
  @PutMapping("/possalesnoodless/{id}")
  public XfR putUpdate(@RequestBody PosSalesNoodles posSalesNoodles,@PathVariable Long id) {
      posSalesNoodles.setId(id);
      return XfR.ok(posSalesNoodlesServiceImpl.updateById(posSalesNoodles));
  }

  /**
   * 修改-传入修改的数据康师傅方便面POS销售数据
   * @param posSalesNoodles 康师傅方便面POS销售数据
   * @return XfR
   */
  @PatchMapping("/possalesnoodless/{id}")
  public XfR patchUpdate(@RequestBody PosSalesNoodles posSalesNoodles,@PathVariable Long id) {
      PosSalesNoodles upposSalesNoodles = posSalesNoodlesServiceImpl.getById(id);
      if(upposSalesNoodles != null){
        upposSalesNoodles = ObjectCopyUtils.copyProperties(posSalesNoodles,upposSalesNoodles,true);
      }
      return XfR.ok(posSalesNoodlesServiceImpl.updateById(upposSalesNoodles));
  }

  /**
   * 通过id删除康师傅方便面POS销售数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/possalesnoodless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(posSalesNoodlesServiceImpl.removeById(id));
  }

  @PostMapping("/possalesnoodless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pos_sales_noodles");
     params.put("request", condition);

     return XfR.ok(posSalesNoodlesServiceImpl.querys(params));
  }

}
