package com.xforceplus.ultraman.app.ksfnoodles.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ksfnoodles.entity.StoreProductKAMapping;
import com.xforceplus.ultraman.app.ksfnoodles.service.IStoreProductKAMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-25
 */
@RestController
public class StoreProductKAMappingController {

  @Autowired
  private IStoreProductKAMappingService storeProductKAMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param storeProductKAMapping ${table.comment}
   * @return
   */
  @GetMapping("/storeproductkamappings" )
  public XfR getStoreProductKAMappings(XfPage page, StoreProductKAMapping storeProductKAMapping) {
    return XfR.ok(storeProductKAMappingServiceImpl.page(page, Wrappers.query(storeProductKAMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/storeproductkamappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(storeProductKAMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param storeProductKAMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/storeproductkamappings")
  public XfR save(@RequestBody StoreProductKAMapping storeProductKAMapping) {
     return XfR.ok(storeProductKAMappingServiceImpl.save(storeProductKAMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param storeProductKAMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/storeproductkamappings/{id}")
  public XfR putUpdate(@RequestBody StoreProductKAMapping storeProductKAMapping,@PathVariable Long id) {
      storeProductKAMapping.setId(id);
      return XfR.ok(storeProductKAMappingServiceImpl.updateById(storeProductKAMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param storeProductKAMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/storeproductkamappings/{id}")
  public XfR patchUpdate(@RequestBody StoreProductKAMapping storeProductKAMapping,@PathVariable Long id) {
      StoreProductKAMapping upstoreProductKAMapping = storeProductKAMappingServiceImpl.getById(id);
      if(upstoreProductKAMapping != null){
        upstoreProductKAMapping = ObjectCopyUtils.copyProperties(storeProductKAMapping,upstoreProductKAMapping,true);
      }
      return XfR.ok(storeProductKAMappingServiceImpl.updateById(upstoreProductKAMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/storeproductkamappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(storeProductKAMappingServiceImpl.removeById(id));
  }

  @PostMapping("/storeproductkamappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "store_product_k_a_mapping");
     params.put("request", condition);

     return XfR.ok(storeProductKAMappingServiceImpl.querys(params));
  }

}
