package com.xforceplus.ultraman.app.ksfnoodles.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ksfnoodles.entity.MessageObjectCache;
import com.xforceplus.ultraman.app.ksfnoodles.service.IMessageObjectCacheService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 康师傅方便面，接收并存储中台消息前端控制器
 *
 * @author ultraman
 * @date 2025-01-15
 */
@RestController
public class MessageObjectCacheController {

  @Autowired
  private IMessageObjectCacheService messageObjectCacheServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param messageObjectCache 康师傅方便面，接收并存储中台消息
   * @return
   */
  @GetMapping("/messageobjectcaches" )
  public XfR getMessageObjectCaches(XfPage page, MessageObjectCache messageObjectCache) {
    return XfR.ok(messageObjectCacheServiceImpl.page(page, Wrappers.query(messageObjectCache)));
  }

  /**
   * 通过id查询康师傅方便面，接收并存储中台消息
   * @param  id
   * @return XfR
   */
  @GetMapping("/messageobjectcaches/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(messageObjectCacheServiceImpl.getById(id));
  }

  /**
   * 新增康师傅方便面，接收并存储中台消息
   * @param messageObjectCache 康师傅方便面，接收并存储中台消息
   * @return XfR
   */
  @PostMapping("/messageobjectcaches")
  public XfR save(@RequestBody MessageObjectCache messageObjectCache) {
     return XfR.ok(messageObjectCacheServiceImpl.save(messageObjectCache));
  }

  /**
   * 修改-传入修改后的全部数据康师傅方便面，接收并存储中台消息
   * @param messageObjectCache 康师傅方便面，接收并存储中台消息
   * @return XfR
   */
  @PutMapping("/messageobjectcaches/{id}")
  public XfR putUpdate(@RequestBody MessageObjectCache messageObjectCache,@PathVariable Long id) {
      messageObjectCache.setId(id);
      return XfR.ok(messageObjectCacheServiceImpl.updateById(messageObjectCache));
  }

  /**
   * 修改-传入修改的数据康师傅方便面，接收并存储中台消息
   * @param messageObjectCache 康师傅方便面，接收并存储中台消息
   * @return XfR
   */
  @PatchMapping("/messageobjectcaches/{id}")
  public XfR patchUpdate(@RequestBody MessageObjectCache messageObjectCache,@PathVariable Long id) {
      MessageObjectCache upmessageObjectCache = messageObjectCacheServiceImpl.getById(id);
      if(upmessageObjectCache != null){
        upmessageObjectCache = ObjectCopyUtils.copyProperties(messageObjectCache,upmessageObjectCache,true);
      }
      return XfR.ok(messageObjectCacheServiceImpl.updateById(upmessageObjectCache));
  }

  /**
   * 通过id删除康师傅方便面，接收并存储中台消息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/messageobjectcaches/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(messageObjectCacheServiceImpl.removeById(id));
  }

  @PostMapping("/messageobjectcaches/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "message_object_cache");
     params.put("request", condition);

     return XfR.ok(messageObjectCacheServiceImpl.querys(params));
  }

}
