package com.xforceplus.ultraman.app.ksfnoodles.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ksfnoodles.entity.MposSalesNoodles;
import com.xforceplus.ultraman.app.ksfnoodles.service.IMposSalesNoodlesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 康师傅方便面POS月销售数据前端控制器
 *
 * @author ultraman
 * @date 2025-01-15
 */
@RestController
public class MposSalesNoodlesController {

  @Autowired
  private IMposSalesNoodlesService mposSalesNoodlesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mposSalesNoodles 康师傅方便面POS月销售数据
   * @return
   */
  @GetMapping("/mpossalesnoodless" )
  public XfR getMposSalesNoodless(XfPage page, MposSalesNoodles mposSalesNoodles) {
    return XfR.ok(mposSalesNoodlesServiceImpl.page(page, Wrappers.query(mposSalesNoodles)));
  }

  /**
   * 通过id查询康师傅方便面POS月销售数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/mpossalesnoodless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mposSalesNoodlesServiceImpl.getById(id));
  }

  /**
   * 新增康师傅方便面POS月销售数据
   * @param mposSalesNoodles 康师傅方便面POS月销售数据
   * @return XfR
   */
  @PostMapping("/mpossalesnoodless")
  public XfR save(@RequestBody MposSalesNoodles mposSalesNoodles) {
     return XfR.ok(mposSalesNoodlesServiceImpl.save(mposSalesNoodles));
  }

  /**
   * 修改-传入修改后的全部数据康师傅方便面POS月销售数据
   * @param mposSalesNoodles 康师傅方便面POS月销售数据
   * @return XfR
   */
  @PutMapping("/mpossalesnoodless/{id}")
  public XfR putUpdate(@RequestBody MposSalesNoodles mposSalesNoodles,@PathVariable Long id) {
      mposSalesNoodles.setId(id);
      return XfR.ok(mposSalesNoodlesServiceImpl.updateById(mposSalesNoodles));
  }

  /**
   * 修改-传入修改的数据康师傅方便面POS月销售数据
   * @param mposSalesNoodles 康师傅方便面POS月销售数据
   * @return XfR
   */
  @PatchMapping("/mpossalesnoodless/{id}")
  public XfR patchUpdate(@RequestBody MposSalesNoodles mposSalesNoodles,@PathVariable Long id) {
      MposSalesNoodles upmposSalesNoodles = mposSalesNoodlesServiceImpl.getById(id);
      if(upmposSalesNoodles != null){
        upmposSalesNoodles = ObjectCopyUtils.copyProperties(mposSalesNoodles,upmposSalesNoodles,true);
      }
      return XfR.ok(mposSalesNoodlesServiceImpl.updateById(upmposSalesNoodles));
  }

  /**
   * 通过id删除康师傅方便面POS月销售数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mpossalesnoodless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mposSalesNoodlesServiceImpl.removeById(id));
  }

  @PostMapping("/mpossalesnoodless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mpos_sales_noodles");
     params.put("request", condition);

     return XfR.ok(mposSalesNoodlesServiceImpl.querys(params));
  }

}
