package com.xforceplus.ultraman.app.ksfnoodles.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ksfnoodles.entity.ProductSalesMapping;
import com.xforceplus.ultraman.app.ksfnoodles.service.IProductSalesMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-15
 */
@RestController
public class ProductSalesMappingController {

  @Autowired
  private IProductSalesMappingService productSalesMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productSalesMapping ${table.comment}
   * @return
   */
  @GetMapping("/productsalesmappings" )
  public XfR getProductSalesMappings(XfPage page, ProductSalesMapping productSalesMapping) {
    return XfR.ok(productSalesMappingServiceImpl.page(page, Wrappers.query(productSalesMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/productsalesmappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productSalesMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param productSalesMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/productsalesmappings")
  public XfR save(@RequestBody ProductSalesMapping productSalesMapping) {
     return XfR.ok(productSalesMappingServiceImpl.save(productSalesMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param productSalesMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/productsalesmappings/{id}")
  public XfR putUpdate(@RequestBody ProductSalesMapping productSalesMapping,@PathVariable Long id) {
      productSalesMapping.setId(id);
      return XfR.ok(productSalesMappingServiceImpl.updateById(productSalesMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param productSalesMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/productsalesmappings/{id}")
  public XfR patchUpdate(@RequestBody ProductSalesMapping productSalesMapping,@PathVariable Long id) {
      ProductSalesMapping upproductSalesMapping = productSalesMappingServiceImpl.getById(id);
      if(upproductSalesMapping != null){
        upproductSalesMapping = ObjectCopyUtils.copyProperties(productSalesMapping,upproductSalesMapping,true);
      }
      return XfR.ok(productSalesMappingServiceImpl.updateById(upproductSalesMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productsalesmappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productSalesMappingServiceImpl.removeById(id));
  }

  @PostMapping("/productsalesmappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_sales_mapping");
     params.put("request", condition);

     return XfR.ok(productSalesMappingServiceImpl.querys(params));
  }

}
