package com.xforceplus.ultraman.app.ksfnoodles.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ksfnoodles.entity.SystemResource;
import com.xforceplus.ultraman.app.ksfnoodles.service.ISystemResourceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 资源系统对象前端控制器
 *
 * @author ultraman
 * @date 2025-01-15
 */
@RestController
public class SystemResourceController {

  @Autowired
  private ISystemResourceService systemResourceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemResource 资源系统对象
   * @return
   */
  @GetMapping("/systemresources" )
  public XfR getSystemResources(XfPage page, SystemResource systemResource) {
    return XfR.ok(systemResourceServiceImpl.page(page, Wrappers.query(systemResource)));
  }

  /**
   * 通过id查询资源系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemresources/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemResourceServiceImpl.getById(id));
  }

  /**
   * 新增资源系统对象
   * @param systemResource 资源系统对象
   * @return XfR
   */
  @PostMapping("/systemresources")
  public XfR save(@RequestBody SystemResource systemResource) {
     return XfR.ok(systemResourceServiceImpl.save(systemResource));
  }

  /**
   * 修改-传入修改后的全部数据资源系统对象
   * @param systemResource 资源系统对象
   * @return XfR
   */
  @PutMapping("/systemresources/{id}")
  public XfR putUpdate(@RequestBody SystemResource systemResource,@PathVariable Long id) {
      systemResource.setId(id);
      return XfR.ok(systemResourceServiceImpl.updateById(systemResource));
  }

  /**
   * 修改-传入修改的数据资源系统对象
   * @param systemResource 资源系统对象
   * @return XfR
   */
  @PatchMapping("/systemresources/{id}")
  public XfR patchUpdate(@RequestBody SystemResource systemResource,@PathVariable Long id) {
      SystemResource upsystemResource = systemResourceServiceImpl.getById(id);
      if(upsystemResource != null){
        upsystemResource = ObjectCopyUtils.copyProperties(systemResource,upsystemResource,true);
      }
      return XfR.ok(systemResourceServiceImpl.updateById(upsystemResource));
  }

  /**
   * 通过id删除资源系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemresources/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemResourceServiceImpl.removeById(id));
  }

  @PostMapping("/systemresources/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_resource");
     params.put("request", condition);

     return XfR.ok(systemResourceServiceImpl.querys(params));
  }

}
