package com.xforceplus.ultraman.app.matchingassets.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 票据明细子对象
 * </p>
 *
 * @author ultraman
 * @since 2022-08-10
 */
public enum BillDocumentItemSonType {

    INVOICE_ITEM("invoiceItem", "发票明细");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillDocumentItemSonType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillDocumentItemSonType fromCode(String code){
        switch(code) {
            case "invoiceItem":
                return INVOICE_ITEM;
            default:
                return null;
        }
    }
}
