package com.xforceplus.ultraman.app.matchingassets.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 票据子对象
 * </p>
 *
 * @author ultraman
 * @since 2022-08-10
 */
public enum BillDocumentSonType {

    INVOICE("invoice", "发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillDocumentSonType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillDocumentSonType fromCode(String code){
        switch(code) {
            case "invoice":
                return INVOICE;
            default:
                return null;
        }
    }
}
